/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import io.bytom.api.Receiver;
import io.bytom.common.ParameterizedTypeImpl;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.exception.JSONException;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class Account {
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="alias")
    public String alias;
    @SerializedName(value="key_index")
    public Integer key_index;
    @SerializedName(value="quorum")
    public Integer quorum;
    @SerializedName(value="xpubs")
    public List<String> xpubs;
    private static Logger logger = Logger.getLogger(Account.class);

    public String toJson() {
        return Utils.serializer.toJson((Object)this);
    }

    public static Account create(Client client, Builder builder) throws BytomException {
        Account account = (Account)client.request("create-account", builder, (Type)((Object)Account.class));
        logger.info((Object)"create-account");
        logger.info((Object)account.toString());
        return account;
    }

    public static List<Account> list(Client client) throws BytomException {
        ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{Account.class});
        List accountList = (List)client.request("list-accounts", null, listType);
        logger.info((Object)"list-accounts:");
        logger.info((Object)("size of accountList:" + accountList.size()));
        logger.info((Object)accountList);
        return accountList;
    }

    public static void delete(Client client, String account_info) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("account_info", account_info);
        client.request("delete-account", req);
    }

    public String toString() {
        return "Account{id='" + this.id + '\'' + ", alias='" + this.alias + '\'' + ", key_index=" + this.key_index + ", quorum=" + this.quorum + ", xpubs=" + this.xpubs + '}';
    }

    public static class AddressBuilder {
        @SerializedName(value="account_alias")
        public String accountAlias;
        @SerializedName(value="account_id")
        public String accountId;

        public AddressBuilder setAccountAlias(String alias) {
            this.accountAlias = alias;
            return this;
        }

        public AddressBuilder setAccountId(String id) {
            this.accountId = id;
            return this;
        }

        public List<Address> list(Client client) throws BytomException {
            ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{Address.class});
            List addressList = (List)client.request("list-addresses", this, listType);
            logger.info((Object)"list-addresses:");
            logger.info((Object)("size of addressList:" + addressList.size()));
            logger.info((Object)((Address)addressList.get(0)).toJson());
            return addressList;
        }

        public Address validate(Client client, String address) throws BytomException {
            HashMap<String, String> req = new HashMap<String, String>();
            req.put("address", address);
            Address addressResult = (Address)client.request("validate-address", req, (Type)((Object)Address.class));
            logger.info((Object)"validate-address:");
            logger.info((Object)addressResult.toJson());
            return addressResult;
        }

        public String toString() {
            return "AddressBuilder{accountAlias='" + this.accountAlias + '\'' + ", accountId='" + this.accountId + '\'' + '}';
        }
    }

    public static class Address {
        @SerializedName(value="account_alias")
        public String accountAlias;
        @SerializedName(value="account_id")
        public String accountId;
        @SerializedName(value="address")
        public String address;
        @SerializedName(value="change")
        public Boolean change;
        @SerializedName(value="vaild")
        public Boolean vaild;
        @SerializedName(value="is_local")
        public Boolean is_local;

        public String toJson() {
            return Utils.serializer.toJson((Object)this);
        }

        public static Address fromJson(String json) throws JSONException {
            try {
                return (Address)Utils.serializer.fromJson(json, Address.class);
            }
            catch (IllegalStateException e) {
                throw new JSONException("Unable to parse serialized receiver: " + e.getMessage());
            }
        }
    }

    public static class ReceiverBuilder {
        @SerializedName(value="account_alias")
        public String accountAlias;
        @SerializedName(value="account_id")
        public String accountId;

        public ReceiverBuilder setAccountAlias(String alias) {
            this.accountAlias = alias;
            return this;
        }

        public ReceiverBuilder setAccountId(String id) {
            this.accountId = id;
            return this;
        }

        public Receiver create(Client client) throws BytomException {
            Gson gson = new Gson();
            Receiver receiver = (Receiver)client.request("create-account-receiver", this, (Type)((Object)Receiver.class));
            logger.info((Object)"create-account-receiver:");
            logger.info((Object)receiver.toJson());
            return receiver;
        }

        public String toString() {
            return "ReceiverBuilder{accountAlias='" + this.accountAlias + '\'' + ", accountId='" + this.accountId + '\'' + '}';
        }
    }

    public static class Builder {
        public List<String> root_xpubs;
        public String alias;
        public Integer quorum;

        public Builder addRootXpub(String xpub) {
            this.root_xpubs.add(xpub);
            return this;
        }

        public Builder setRootXpub(List<String> xpubs) {
            this.root_xpubs = new ArrayList<String>(xpubs);
            return this;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setQuorum(Integer quorum) {
            this.quorum = quorum;
            return this;
        }
    }
}

