/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.common.ParameterizedTypeImpl;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class AccessToken {
    public String id;
    public String token;
    public String type;
    @SerializedName(value="created_at", alternate={"create"})
    public String createTime;
    private static Logger logger = Logger.getLogger(AccessToken.class);

    public String toJson() {
        return Utils.serializer.toJson((Object)this);
    }

    public static void check(Client client, String id, String secret) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("id", id);
        req.put("secret", secret);
        if (client.getUrl().equals("http://127.0.0.1:9888") || client.getUrl().equals("http://127.0.0.1:9888/")) {
            client.request("check-access-token", req);
            logger.info((Object)"check-access-token successfully.");
        } else {
            logger.info((Object)"this is a native method.");
        }
    }

    public static void delete(Client client, String id) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("id", id);
        if (client.getUrl().equals("http://127.0.0.1:9888") || client.getUrl().equals("http://127.0.0.1:9888/")) {
            client.request("delete-access-token", req);
            logger.info((Object)"delete-access-token.");
        } else {
            logger.info((Object)"this is a native method.");
        }
    }

    public static List<AccessToken> list(Client client) throws BytomException {
        ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{AccessToken.class});
        List accessTokenList = null;
        if (client.getUrl().equals("http://127.0.0.1:9888") || client.getUrl().equals("http://127.0.0.1:9888/")) {
            accessTokenList = (List)client.request("list-access-tokens", null, listType);
            logger.info((Object)"list-access-tokens:");
            logger.info((Object)("size of accessTokenList:" + accessTokenList.size()));
            logger.info((Object)((AccessToken)accessTokenList.get(0)).toJson());
        } else {
            logger.info((Object)"this is a native method.");
        }
        return accessTokenList;
    }

    public static class Builder {
        public String id;
        public String type;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public AccessToken create(Client client) throws BytomException {
            AccessToken accessToken = (AccessToken)client.request("create-access-token", this, (Type)((Object)AccessToken.class));
            logger.info((Object)"create-access-token:");
            logger.info((Object)accessToken.toJson());
            return accessToken;
        }
    }
}

