/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.util.time;

import io.buybrain.util.Tuple2;
import io.buybrain.util.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Periods {
    public static List<Period> merge(@NonNull List<Period> a, @NonNull List<Period> b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        ArrayList<Period> allPeriods = new ArrayList<Period>();
        allPeriods.addAll(a);
        allPeriods.addAll(b);
        return Periods.merge(allPeriods);
    }

    public static List<Period> merge(@NonNull List<Period> periods) {
        if (periods == null) {
            throw new NullPointerException("periods");
        }
        periods.sort(Comparator.comparing(Period::getFrom));
        ArrayList<Period> result = new ArrayList<Period>();
        ZonedDateTime curStart = null;
        ZonedDateTime curEnd = null;
        for (Period period : periods) {
            if (curStart == null) {
                curStart = period.getFrom();
                curEnd = period.getTo();
                continue;
            }
            if (!period.getFrom().isAfter(curEnd)) {
                if (!period.getTo().isAfter(curEnd)) continue;
                curEnd = period.getTo();
                continue;
            }
            result.add(new Period(curStart, curEnd));
            curStart = period.getFrom();
            curEnd = period.getTo();
        }
        if (curStart != null) {
            result.add(new Period(curStart, curEnd));
        }
        return result;
    }

    public static List<Period> subtract(@NonNull List<Period> subjects, @NonNull Period toSubtract) {
        if (subjects == null) {
            throw new NullPointerException("subjects");
        }
        if (toSubtract == null) {
            throw new NullPointerException("toSubtract");
        }
        return subjects.stream().flatMap(p -> Periods.subtract(p, toSubtract).stream()).collect(Collectors.toList());
    }

    public static List<Period> subtract(@NonNull Period subject, @NonNull Period toSubtract) {
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        if (toSubtract == null) {
            throw new NullPointerException("toSubtract");
        }
        ArrayList<Period> result = new ArrayList<Period>();
        if (toSubtract.getFrom().isAfter(subject.getFrom())) {
            result.add(new Period(subject.getFrom(), Periods.min(toSubtract.getFrom(), subject.getTo())));
        }
        if (toSubtract.getTo().isBefore(subject.getTo())) {
            result.add(new Period(Periods.max(toSubtract.getTo(), subject.getFrom()), subject.getTo()));
        }
        return result;
    }

    public static Optional<Period> intersect(@NonNull Period a, @NonNull Period b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        List<Period> i = Periods.intersect(Collections.singletonList(a), Collections.singletonList(b));
        return i.isEmpty() ? Optional.empty() : Optional.of(i.get(0));
    }

    public static List<Period> intersect(@NonNull List<Period> a, @NonNull List<Period> b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        ArrayList<Tuple2> deltas = new ArrayList<Tuple2>();
        for (List set : Arrays.asList(a, b)) {
            for (Period p : set) {
                deltas.add(new Tuple2<ZonedDateTime, Integer>(p.getFrom(), 1));
                deltas.add(new Tuple2<ZonedDateTime, Integer>(p.getTo(), -1));
            }
        }
        deltas.sort(Comparator.comparing(Tuple2::getFirst));
        ArrayList<Period> result = new ArrayList<Period>();
        int counter = 0;
        ZonedDateTime curStart = null;
        for (Tuple2 delta : deltas) {
            if ((counter += ((Integer)delta.getSecond()).intValue()) == 2) {
                curStart = (ZonedDateTime)delta.getFirst();
                continue;
            }
            if (curStart == null) continue;
            result.add(new Period(curStart, (ZonedDateTime)delta.getFirst()));
            curStart = null;
        }
        return result;
    }

    private static ZonedDateTime min(ZonedDateTime a, ZonedDateTime b) {
        return a.isBefore(b) ? a : b;
    }

    private static ZonedDateTime max(ZonedDateTime a, ZonedDateTime b) {
        return a.isBefore(b) ? b : a;
    }
}

