/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.util.time;

import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalUnit;
import lombok.NonNull;

public final class Period {
    @NonNull
    private final ZonedDateTime from;
    @NonNull
    private final ZonedDateTime to;

    public long length(@NonNull TemporalUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        return this.from.until(this.to, unit);
    }

    @ConstructorProperties(value={"from", "to"})
    public Period(@NonNull ZonedDateTime from, @NonNull ZonedDateTime to) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        if (to == null) {
            throw new NullPointerException("to");
        }
        this.from = from;
        this.to = to;
    }

    @NonNull
    public ZonedDateTime getFrom() {
        return this.from;
    }

    @NonNull
    public ZonedDateTime getTo() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Period)) {
            return false;
        }
        Period other = (Period)o;
        ZonedDateTime this$from = this.getFrom();
        ZonedDateTime other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        ZonedDateTime this$to = this.getTo();
        ZonedDateTime other$to = other.getTo();
        return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZonedDateTime $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        ZonedDateTime $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        return result;
    }

    public String toString() {
        return "Period(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }
}

