/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.util.time;

import io.buybrain.util.time.Clock;
import java.time.Duration;
import java.time.Instant;
import lombok.NonNull;

public class MockClock
implements Clock {
    private Instant time;

    public MockClock() {
        this(Instant.EPOCH);
    }

    public MockClock(@NonNull Instant time) {
        if (time == null) {
            throw new NullPointerException("time");
        }
        this.time = time;
    }

    @Override
    public Instant now() {
        return this.time;
    }

    @Override
    public void sleep(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration");
        }
        this.time = this.time.plus(duration);
    }
}

