/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.util;

import io.buybrain.util.function.ThrowingRunnable;
import io.buybrain.util.function.ThrowingSupplier;
import io.buybrain.util.time.Sleeper;
import io.buybrain.util.time.SystemClock;
import java.time.Duration;
import java.util.Random;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retryer {
    private static final Logger log = LoggerFactory.getLogger(Retryer.class);

    public static RunnableRetryer of(@NonNull ThrowingRunnable job) {
        if (job == null) {
            throw new NullPointerException("job");
        }
        return new RunnableRetryer(job);
    }

    public static <T> SupplierRetryer<T> of(@NonNull ThrowingSupplier<T> job) {
        if (job == null) {
            throw new NullPointerException("job");
        }
        return new SupplierRetryer(job);
    }

    public static class SupplierRetryer<T>
    extends BaseRetryer<T, SupplierRetryer<T>> {
        private final ThrowingSupplier<T> job;

        public T run() throws Throwable {
            this.resolve();
            return (T)this.returnValue;
        }

        @Override
        protected T execute() throws Throwable {
            return this.job.get();
        }

        private SupplierRetryer(ThrowingSupplier<T> job) {
            this.job = job;
        }
    }

    public static class RunnableRetryer
    extends BaseRetryer<Void, RunnableRetryer> {
        private final ThrowingRunnable job;

        public void run() throws Throwable {
            this.resolve();
        }

        @Override
        protected Void execute() throws Throwable {
            this.job.run();
            return null;
        }

        private RunnableRetryer(ThrowingRunnable job) {
            this.job = job;
        }
    }

    private static abstract class BaseRetryer<T, R extends BaseRetryer> {
        private int maxAttempts = 0;
        private Duration baseDelay = Duration.ofSeconds(1L);
        private boolean exponentialBackoff = true;
        private double exponentialFactor = 1.5;
        private boolean randomizeBackoff = false;
        private Long randomSeed = null;
        private Duration maxDelay = Duration.ofSeconds(30L);
        private Sleeper sleeper = SystemClock.get();
        protected T returnValue;

        private BaseRetryer() {
        }

        public R maxAttempts(int max) {
            this.maxAttempts = max;
            return (R)this;
        }

        public R baseDelay(@NonNull Duration delay) {
            if (delay == null) {
                throw new NullPointerException("delay");
            }
            this.baseDelay = delay;
            return (R)this;
        }

        public R exponentialBackoff(boolean exponential) {
            this.exponentialBackoff = exponential;
            return (R)this;
        }

        public R exponentialFactor(double factor) {
            this.exponentialFactor = factor;
            return (R)this;
        }

        public R randomizeBackoff() {
            this.randomizeBackoff = true;
            return (R)this;
        }

        public R randomizeBackoff(long seed) {
            this.randomSeed = seed;
            return this.randomizeBackoff();
        }

        public R maxDelay(@NonNull Duration delay) {
            if (delay == null) {
                throw new NullPointerException("delay");
            }
            this.maxDelay = delay;
            return (R)this;
        }

        public R clock(@NonNull Sleeper clock) {
            if (clock == null) {
                throw new NullPointerException("clock");
            }
            this.sleeper = clock;
            return (R)this;
        }

        protected void resolve() throws Throwable {
            int attempts = 0;
            Duration delay = this.baseDelay;
            Random random = this.randomSeed == null ? new Random() : new Random(this.randomSeed);
            while (true) {
                try {
                    this.returnValue = this.execute();
                    return;
                }
                catch (Throwable ex) {
                    Throwable lastException = ex;
                    if (this.maxAttempts > 0 && ++attempts == this.maxAttempts) {
                        throw lastException;
                    }
                    log.warn("Retryer caught exception, will retry in " + delay, lastException);
                    this.sleeper.sleep(delay);
                    if (!this.exponentialBackoff) continue;
                    delay = this.applyExponentialBackoff(delay, random);
                    continue;
                }
                break;
            }
        }

        private Duration applyExponentialBackoff(Duration currentDelay, Random random) {
            double newDelayNanos = (double)currentDelay.toNanos() * this.exponentialFactor;
            if (this.randomizeBackoff) {
                newDelayNanos *= random.nextDouble() + 0.5;
            }
            if (newDelayNanos <= (double)this.maxDelay.toNanos()) {
                return Duration.ofNanos((long)newDelayNanos);
            }
            return this.maxDelay;
        }

        protected abstract T execute() throws Throwable;
    }
}

