/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.util;

import io.buybrain.util.Exceptions;
import io.buybrain.util.function.ThrowingConsumer;
import io.buybrain.util.function.ThrowingFunction;
import io.buybrain.util.function.ThrowingRunnable;
import io.buybrain.util.function.ThrowingSupplier;
import lombok.NonNull;

public class Result<T, E extends Throwable> {
    private final T value;
    private final E error;

    private Result(T value, E error) {
        this.value = value;
        this.error = error;
    }

    public <R> Result<R, ?> map(@NonNull ThrowingFunction<T, Result<R, ?>> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return Exceptions.rethrowR(op.bind(this.value));
        }
        return this;
    }

    public <R> Result<R, ?> tryMap(@NonNull ThrowingFunction<T, R> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return Result.trying(op.bind(this.value));
        }
        return this;
    }

    public <R> Result<R, ?> andThen(@NonNull ThrowingSupplier<Result<R, ?>> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return Exceptions.rethrowR(op);
        }
        return this;
    }

    public <R> Result<R, ?> andThenTry(@NonNull ThrowingSupplier<R> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return Result.trying(op);
        }
        return this;
    }

    public <R> Result<R, ?> andThen(@NonNull ThrowingConsumer<T> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            Exceptions.rethrow(op.bind(this.value));
            return Result.ok();
        }
        return this;
    }

    public Result<?, ?> andThenTry(@NonNull ThrowingConsumer<T> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return Result.trying(op.bind(this.value));
        }
        return this;
    }

    public <R> Result<R, ?> andThen(@NonNull ThrowingRunnable op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            Exceptions.rethrow(op);
            return Result.ok();
        }
        return this;
    }

    public <R> Result<R, ?> andThenTry(@NonNull ThrowingRunnable op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return Result.trying(op);
        }
        return this;
    }

    public Result<T, ?> orElse(T defaultValue) {
        if (this.isOk()) {
            return this;
        }
        return Result.ok(defaultValue);
    }

    public Result<T, ?> mapErr(@NonNull ThrowingFunction<E, Result<T, ?>> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return this;
        }
        return Exceptions.rethrowR(op.bind(this.error));
    }

    public Result<T, ?> tryMapErr(@NonNull ThrowingFunction<E, T> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return this;
        }
        return Result.trying(op.bind(this.error));
    }

    public Result<T, ?> orElse(@NonNull ThrowingSupplier<Result<T, ?>> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return this;
        }
        return Exceptions.rethrowR(op);
    }

    public Result<T, ?> orElseTry(@NonNull ThrowingSupplier<T> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return this;
        }
        return Result.trying(op);
    }

    public Result<T, ?> orElse(@NonNull ThrowingConsumer<E> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return this;
        }
        Exceptions.rethrow(op.bind(this.error));
        return Result.ok();
    }

    public Result<T, ?> orElseTry(@NonNull ThrowingConsumer<E> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return this;
        }
        return Result.trying(op.bind(this.error));
    }

    public Result<T, ?> orElse(@NonNull ThrowingRunnable op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return this;
        }
        Exceptions.rethrow(op);
        return Result.ok();
    }

    public Result<T, ?> orElseTry(@NonNull ThrowingRunnable op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (this.isOk()) {
            return this;
        }
        return Result.trying(op);
    }

    public T get() throws E {
        if (this.isOk()) {
            return this.value;
        }
        throw this.error;
    }

    public T getUnsafe() {
        return this.value;
    }

    public E getError() {
        return this.error;
    }

    public static <T> Result<T, ?> ok() {
        return new Result<Object, Object>(null, null);
    }

    public static <T> Result<T, ?> trying(@NonNull ThrowingSupplier<T> op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        try {
            return Result.ok(op.get());
        }
        catch (Throwable ex) {
            return Result.err(ex);
        }
    }

    public static <T> Result<T, ?> trying(@NonNull ThrowingRunnable op) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        try {
            op.run();
            return Result.ok();
        }
        catch (Throwable ex) {
            return Result.err(ex);
        }
    }

    public boolean isOk() {
        return this.error == null;
    }

    public static <T> Result<T, ?> ok(T value) {
        return new Result<T, Object>(value, null);
    }

    public static <T, E extends Throwable> Result<T, E> err(@NonNull E error) {
        if (error == null) {
            throw new NullPointerException("error");
        }
        return new Result<Object, E>(null, error);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.value;
        T other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        E this$error = this.getError();
        E other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        E $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }
}

