/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.util;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class QueuedIterator<T>
implements Iterator<T> {
    private final BlockingQueue<Elem> queue;
    private T next;
    private volatile boolean done = false;

    public QueuedIterator(int capacity) {
        this.queue = new ArrayBlockingQueue<Elem>(capacity);
    }

    public void put(T elem) {
        this.queue.put(new Val(elem));
    }

    public void done() {
        this.done = true;
        this.queue.offer(new Done());
    }

    @Override
    public boolean hasNext() {
        this.loadNext();
        return this.next != null;
    }

    @Override
    public T next() {
        this.loadNext();
        if (this.next == null) {
            throw new RuntimeException("Called next() on finished QueuedIterator");
        }
        T result = this.next;
        this.next = null;
        return result;
    }

    private void loadNext() {
        Elem nextVal;
        if (!(this.next != null || this.done && this.queue.isEmpty() || (nextVal = this.queue.take()) instanceof Done)) {
            this.next = ((Val)nextVal).getElem();
        }
    }

    private static class Done
    implements Elem {
        private Done() {
        }
    }

    private final class Val
    implements Elem {
        private final T elem;

        @ConstructorProperties(value={"elem"})
        public Val(T elem) {
            this.elem = elem;
        }

        public T getElem() {
            return this.elem;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Val)) {
                return false;
            }
            Val other = (Val)o;
            Object this$elem = this.getElem();
            Object other$elem = other.getElem();
            return !(this$elem == null ? other$elem != null : !this$elem.equals(other$elem));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $elem = this.getElem();
            result = result * 59 + ($elem == null ? 43 : $elem.hashCode());
            return result;
        }

        public String toString() {
            return "QueuedIterator.Val(elem=" + this.getElem() + ")";
        }
    }

    private static interface Elem {
    }
}

