/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.util;

import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.NonNull;

public class Env {
    private final Map<String, String> env;

    public Env() {
        this(System.getenv());
    }

    public String getString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!this.env.containsKey(key)) {
            throw new IllegalArgumentException("Environment variable " + key + " is not set");
        }
        return this.env.get(key);
    }

    public String getString(@NonNull String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!this.env.containsKey(key)) {
            return defaultValue;
        }
        return this.env.get(key);
    }

    public int getInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return Integer.parseInt(this.getString(key));
    }

    public int getInt(@NonNull String key, int defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return Integer.parseInt(this.getString(key, Integer.toString(defaultValue)));
    }

    @ConstructorProperties(value={"env"})
    public Env(Map<String, String> env) {
        this.env = env;
    }
}

