/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.util.time;

import io.buybrain.util.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class SystemClock
implements Clock {
    private static Clock INSTANCE = new SystemClock();

    private SystemClock() {
    }

    @Override
    public void sleep(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration");
        }
        TimeUnit.NANOSECONDS.sleep(duration.toNanos());
    }

    @Override
    public Instant now() {
        return Instant.now();
    }

    public static Clock get() {
        return INSTANCE;
    }
}

