/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.util;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class QueuedIterator<T>
implements Iterator<T> {
    private final BlockingQueue<Elem> queue;
    private Elem next;

    public QueuedIterator(int capacity) {
        this.queue = new ArrayBlockingQueue<Elem>(capacity);
    }

    public void put(T elem) {
        this.queue.put(new Val(elem));
    }

    public void done() {
        this.queue.put(new Done());
    }

    @Override
    public boolean hasNext() {
        return !(this.fetchNext() instanceof Done);
    }

    @Override
    public T next() {
        Elem next = this.fetchNext();
        if (next instanceof Done) {
            throw new RuntimeException("Called next() on finished QueuedIterator");
        }
        this.next = null;
        return ((Val)next).getElem();
    }

    private Elem fetchNext() {
        if (this.next == null) {
            this.next = this.queue.take();
        }
        return this.next;
    }

    private static class Done
    implements Elem {
        private Done() {
        }
    }

    private final class Val
    implements Elem {
        private final T elem;

        @ConstructorProperties(value={"elem"})
        public Val(T elem) {
            this.elem = elem;
        }

        public T getElem() {
            return this.elem;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Val)) {
                return false;
            }
            Val other = (Val)o;
            Object this$elem = this.getElem();
            Object other$elem = other.getElem();
            return !(this$elem == null ? other$elem != null : !this$elem.equals(other$elem));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $elem = this.getElem();
            result = result * 59 + ($elem == null ? 43 : $elem.hashCode());
            return result;
        }

        public String toString() {
            return "QueuedIterator.Val(elem=" + this.getElem() + ")";
        }
    }

    private static interface Elem {
    }
}

