/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.util;

import io.buybrain.util.function.ThrowingConsumer;
import io.buybrain.util.function.ThrowingFunction;
import io.buybrain.util.function.ThrowingRunnable;
import io.buybrain.util.function.ThrowingSupplier;
import java.util.function.Function;
import java.util.function.Supplier;

public class Result<T, E extends Throwable> {
    private final T value;
    private final E error;

    private Result(T value, E error) {
        this.value = value;
        this.error = error;
    }

    public <R> Result<R, ?> andThen(Function<T, Result<R, ?>> op) {
        if (this.isOk()) {
            return op.apply(this.value);
        }
        return this;
    }

    public <R> Result<R, ?> andThenTry(ThrowingFunction<T, R> op) {
        if (this.isOk()) {
            return Result.trying(op.bind(this.value));
        }
        return this;
    }

    public <R> Result<R, ?> andThen(Supplier<Result<R, ?>> op) {
        if (this.isOk()) {
            return op.get();
        }
        return this;
    }

    public Result<?, ?> andThenTry(ThrowingConsumer<T> op) {
        if (this.isOk()) {
            return Result.trying(op.bind(this.value));
        }
        return this;
    }

    public <R> Result<R, ?> andThenTry(ThrowingRunnable op) {
        if (this.isOk()) {
            return Result.trying(op);
        }
        return this;
    }

    public Result<T, ?> orElse(Function<E, Result<T, ?>> op) {
        if (this.isOk()) {
            return this;
        }
        return op.apply(this.error);
    }

    public Result<T, ?> orElse(Supplier<Result<T, ?>> op) {
        if (this.isOk()) {
            return this;
        }
        return op.get();
    }

    public static <T> Result<T, ?> ok() {
        return new Result<Object, Object>(null, null);
    }

    public static <T> Result<T, ?> trying(ThrowingSupplier<T> op) {
        try {
            return Result.ok(op.get());
        }
        catch (Exception ex) {
            return Result.err(ex);
        }
    }

    public static <T> Result<T, ?> trying(ThrowingRunnable op) {
        try {
            op.run();
            return Result.ok();
        }
        catch (Exception ex) {
            return Result.err(ex);
        }
    }

    public boolean isOk() {
        return this.error == null;
    }

    public static <T> Result<T, ?> ok(T value) {
        return new Result<T, Object>(value, null);
    }

    public static <T, E extends Throwable> Result<T, E> err(E error) {
        return new Result<Object, E>(null, error);
    }
}

