/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.util;

import io.buybrain.util.function.ThrowingConsumer;
import io.buybrain.util.function.ThrowingFunction;
import io.buybrain.util.function.ThrowingRunnable;
import io.buybrain.util.function.ThrowingSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public class Exceptions {
    public static <T> T rethrowR(@NonNull ThrowingSupplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        try {
            return supplier.get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void rethrow(@NonNull ThrowingRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        try {
            runnable.run();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T, R> Function<T, R> rethrowR(@NonNull ThrowingFunction<T, R> func) {
        if (func == null) {
            throw new NullPointerException("func");
        }
        return in -> {
            try {
                return func.apply(in);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static <T> Consumer<T> rethrow(@NonNull ThrowingConsumer<T> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer");
        }
        return in -> {
            try {
                consumer.accept(in);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }
}

