/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.hamq;

import io.buybrain.hamq.Delivery;
import io.buybrain.hamq.OperationSpec;
import io.buybrain.util.function.ThrowingConsumer;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public final class ConsumeSpec
extends OperationSpec<ConsumeSpec> {
    @NonNull
    private final String queue;
    @NonNull
    private final ThrowingConsumer<Delivery> callback;
    private final boolean noLocal;
    private final boolean exclusive;
    @NonNull
    private final Map<String, Object> args;

    public ConsumeSpec(@NonNull String queue, @NonNull ThrowingConsumer<Delivery> callback) {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        this.queue = queue;
        this.callback = callback;
        this.noLocal = false;
        this.exclusive = false;
        this.args = Collections.emptyMap();
    }

    public ConsumeSpec withArg(@NonNull String name, @NonNull Object value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        HashMap<String, Object> newArgs = new HashMap<String, Object>(this.args);
        newArgs.put(name, value);
        return this.withArgs(newArgs);
    }

    @NonNull
    public String getQueue() {
        return this.queue;
    }

    @NonNull
    public ThrowingConsumer<Delivery> getCallback() {
        return this.callback;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    @NonNull
    public Map<String, Object> getArgs() {
        return this.args;
    }

    public String toString() {
        return "ConsumeSpec(queue=" + this.getQueue() + ", callback=" + this.getCallback() + ", noLocal=" + this.isNoLocal() + ", exclusive=" + this.isExclusive() + ", args=" + this.getArgs() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumeSpec)) {
            return false;
        }
        ConsumeSpec other = (ConsumeSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$queue = this.getQueue();
        String other$queue = other.getQueue();
        if (this$queue == null ? other$queue != null : !this$queue.equals(other$queue)) {
            return false;
        }
        ThrowingConsumer<Delivery> this$callback = this.getCallback();
        ThrowingConsumer<Delivery> other$callback = other.getCallback();
        if (this$callback == null ? other$callback != null : !this$callback.equals(other$callback)) {
            return false;
        }
        if (this.isNoLocal() != other.isNoLocal()) {
            return false;
        }
        if (this.isExclusive() != other.isExclusive()) {
            return false;
        }
        Map<String, Object> this$args = this.getArgs();
        Map<String, Object> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsumeSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $queue = this.getQueue();
        result = result * 59 + ($queue == null ? 43 : $queue.hashCode());
        ThrowingConsumer<Delivery> $callback = this.getCallback();
        result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
        result = result * 59 + (this.isNoLocal() ? 79 : 97);
        result = result * 59 + (this.isExclusive() ? 79 : 97);
        Map<String, Object> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    public ConsumeSpec withQueue(@NonNull String queue) {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        return this.queue == queue ? this : new ConsumeSpec(queue, this.callback, this.noLocal, this.exclusive, this.args);
    }

    public ConsumeSpec withCallback(@NonNull ThrowingConsumer<Delivery> callback) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        return this.callback == callback ? this : new ConsumeSpec(this.queue, callback, this.noLocal, this.exclusive, this.args);
    }

    public ConsumeSpec withNoLocal(boolean noLocal) {
        return this.noLocal == noLocal ? this : new ConsumeSpec(this.queue, this.callback, noLocal, this.exclusive, this.args);
    }

    public ConsumeSpec withExclusive(boolean exclusive) {
        return this.exclusive == exclusive ? this : new ConsumeSpec(this.queue, this.callback, this.noLocal, exclusive, this.args);
    }

    public ConsumeSpec withArgs(@NonNull Map<String, Object> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        return this.args == args ? this : new ConsumeSpec(this.queue, this.callback, this.noLocal, this.exclusive, args);
    }

    @ConstructorProperties(value={"queue", "callback", "noLocal", "exclusive", "args"})
    public ConsumeSpec(@NonNull String queue, @NonNull ThrowingConsumer<Delivery> callback, boolean noLocal, boolean exclusive, @NonNull Map<String, Object> args) {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.queue = queue;
        this.callback = callback;
        this.noLocal = noLocal;
        this.exclusive = exclusive;
        this.args = args;
    }
}

