/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.hamq;

import io.buybrain.hamq.RetryPolicy;
import io.buybrain.util.Env;
import java.beans.ConstructorProperties;
import lombok.NonNull;

public final class Config {
    @NonNull
    private final String host;
    private final int port;
    @NonNull
    private final String username;
    @NonNull
    private final String password;
    @NonNull
    private final String vhost;
    @NonNull
    private final RetryPolicy retryPolicy;

    public Config() {
        this.host = "localhost";
        this.port = 5672;
        this.username = "guest";
        this.password = "guest";
        this.vhost = "/";
        this.retryPolicy = new RetryPolicy();
    }

    public static Config ofEnv(@NonNull Env env) {
        if (env == null) {
            throw new NullPointerException("env");
        }
        return Config.ofEnv(env, "AMQP_");
    }

    public static Config ofEnv(@NonNull Env env, @NonNull String prefix) {
        if (env == null) {
            throw new NullPointerException("env");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        Config config = new Config();
        return config.withHost(env.getString(prefix + "HOST", config.getHost())).withPort(env.getInt(prefix + "PORT", config.getPort())).withUsername(env.getString(prefix + "USER", config.getUsername())).withPassword(env.getString(prefix + "PASS", config.getPassword())).withVhost(env.getString(prefix + "VHOST", config.getVhost()));
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @NonNull
    public String getPassword() {
        return this.password;
    }

    @NonNull
    public String getVhost() {
        return this.vhost;
    }

    @NonNull
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$vhost = this.getVhost();
        String other$vhost = other.getVhost();
        if (this$vhost == null ? other$vhost != null : !this$vhost.equals(other$vhost)) {
            return false;
        }
        RetryPolicy this$retryPolicy = this.getRetryPolicy();
        RetryPolicy other$retryPolicy = other.getRetryPolicy();
        return !(this$retryPolicy == null ? other$retryPolicy != null : !((Object)this$retryPolicy).equals(other$retryPolicy));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $vhost = this.getVhost();
        result = result * 59 + ($vhost == null ? 43 : $vhost.hashCode());
        RetryPolicy $retryPolicy = this.getRetryPolicy();
        result = result * 59 + ($retryPolicy == null ? 43 : ((Object)$retryPolicy).hashCode());
        return result;
    }

    public String toString() {
        return "Config(host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", vhost=" + this.getVhost() + ", retryPolicy=" + this.getRetryPolicy() + ")";
    }

    public Config withHost(@NonNull String host) {
        if (host == null) {
            throw new NullPointerException("host");
        }
        return this.host == host ? this : new Config(host, this.port, this.username, this.password, this.vhost, this.retryPolicy);
    }

    public Config withPort(int port) {
        return this.port == port ? this : new Config(this.host, port, this.username, this.password, this.vhost, this.retryPolicy);
    }

    public Config withUsername(@NonNull String username) {
        if (username == null) {
            throw new NullPointerException("username");
        }
        return this.username == username ? this : new Config(this.host, this.port, username, this.password, this.vhost, this.retryPolicy);
    }

    public Config withPassword(@NonNull String password) {
        if (password == null) {
            throw new NullPointerException("password");
        }
        return this.password == password ? this : new Config(this.host, this.port, this.username, password, this.vhost, this.retryPolicy);
    }

    public Config withVhost(@NonNull String vhost) {
        if (vhost == null) {
            throw new NullPointerException("vhost");
        }
        return this.vhost == vhost ? this : new Config(this.host, this.port, this.username, this.password, vhost, this.retryPolicy);
    }

    public Config withRetryPolicy(@NonNull RetryPolicy retryPolicy) {
        if (retryPolicy == null) {
            throw new NullPointerException("retryPolicy");
        }
        return this.retryPolicy == retryPolicy ? this : new Config(this.host, this.port, this.username, this.password, this.vhost, retryPolicy);
    }

    @ConstructorProperties(value={"host", "port", "username", "password", "vhost", "retryPolicy"})
    public Config(@NonNull String host, int port, @NonNull String username, @NonNull String password, @NonNull String vhost, @NonNull RetryPolicy retryPolicy) {
        if (host == null) {
            throw new NullPointerException("host");
        }
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (vhost == null) {
            throw new NullPointerException("vhost");
        }
        if (retryPolicy == null) {
            throw new NullPointerException("retryPolicy");
        }
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.vhost = vhost;
        this.retryPolicy = retryPolicy;
    }
}

