/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.hamq;

import io.buybrain.hamq.OperationSpec;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public final class BindSpec
extends OperationSpec<BindSpec> {
    @NonNull
    private final String queue;
    @NonNull
    private final String exchange;
    @NonNull
    private final String routingKey;
    @NonNull
    private final Map<String, Object> args;

    public BindSpec(@NonNull String queue, @NonNull String exchange) {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        if (exchange == null) {
            throw new NullPointerException("exchange");
        }
        this.queue = queue;
        this.exchange = exchange;
        this.routingKey = "";
        this.args = Collections.emptyMap();
    }

    BindSpec withArg(@NonNull String name, @NonNull Object value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        HashMap<String, Object> newArgs = new HashMap<String, Object>(this.args);
        newArgs.put(name, value);
        return this.withArgs(newArgs);
    }

    @NonNull
    public String getQueue() {
        return this.queue;
    }

    @NonNull
    public String getExchange() {
        return this.exchange;
    }

    @NonNull
    public String getRoutingKey() {
        return this.routingKey;
    }

    @NonNull
    public Map<String, Object> getArgs() {
        return this.args;
    }

    public String toString() {
        return "BindSpec(queue=" + this.getQueue() + ", exchange=" + this.getExchange() + ", routingKey=" + this.getRoutingKey() + ", args=" + this.getArgs() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BindSpec)) {
            return false;
        }
        BindSpec other = (BindSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$queue = this.getQueue();
        String other$queue = other.getQueue();
        if (this$queue == null ? other$queue != null : !this$queue.equals(other$queue)) {
            return false;
        }
        String this$exchange = this.getExchange();
        String other$exchange = other.getExchange();
        if (this$exchange == null ? other$exchange != null : !this$exchange.equals(other$exchange)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        Map<String, Object> this$args = this.getArgs();
        Map<String, Object> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BindSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $queue = this.getQueue();
        result = result * 59 + ($queue == null ? 43 : $queue.hashCode());
        String $exchange = this.getExchange();
        result = result * 59 + ($exchange == null ? 43 : $exchange.hashCode());
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        Map<String, Object> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    public BindSpec withQueue(@NonNull String queue) {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        return this.queue == queue ? this : new BindSpec(queue, this.exchange, this.routingKey, this.args);
    }

    public BindSpec withExchange(@NonNull String exchange) {
        if (exchange == null) {
            throw new NullPointerException("exchange");
        }
        return this.exchange == exchange ? this : new BindSpec(this.queue, exchange, this.routingKey, this.args);
    }

    public BindSpec withRoutingKey(@NonNull String routingKey) {
        if (routingKey == null) {
            throw new NullPointerException("routingKey");
        }
        return this.routingKey == routingKey ? this : new BindSpec(this.queue, this.exchange, routingKey, this.args);
    }

    public BindSpec withArgs(@NonNull Map<String, Object> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        return this.args == args ? this : new BindSpec(this.queue, this.exchange, this.routingKey, args);
    }

    @ConstructorProperties(value={"queue", "exchange", "routingKey", "args"})
    public BindSpec(@NonNull String queue, @NonNull String exchange, @NonNull String routingKey, @NonNull Map<String, Object> args) {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        if (exchange == null) {
            throw new NullPointerException("exchange");
        }
        if (routingKey == null) {
            throw new NullPointerException("routingKey");
        }
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.queue = queue;
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.args = args;
    }
}

