/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.hamq;

import com.rabbitmq.client.ShutdownSignalException;
import io.buybrain.hamq.RetryPolicy;
import io.buybrain.util.Result;
import io.buybrain.util.function.ThrowingRunnable;
import io.buybrain.util.function.ThrowingSupplier;
import io.buybrain.util.time.Clock;
import io.buybrain.util.time.SystemClock;
import java.net.SocketException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Retryer {
    private static final Logger log = LoggerFactory.getLogger(Retryer.class);
    private Clock clock = SystemClock.get();

    Retryer() {
    }

    void performWithRetry(@NonNull ThrowingRunnable operation, @NonNull RetryPolicy policy) {
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        RetryState state = new RetryState();
        while (!Result.trying((ThrowingRunnable)operation).mapErr(ex -> this.handleError((Throwable)ex, policy, state)).isOk()) {
        }
    }

    <T> T performWithRetry(@NonNull ThrowingSupplier<T> operation, @NonNull RetryPolicy policy) {
        Result result;
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        RetryState state = new RetryState();
        while (!(result = Result.trying(operation).mapErr(ex -> this.handleError((Throwable)ex, policy, state))).isOk()) {
        }
        return (T)result.getUnsafe();
    }

    private Result handleError(Throwable ex, RetryPolicy policy, RetryState state) throws Throwable {
        if (this.isRetryable(ex, policy)) {
            log.warn("Encountered error, will retry later", ex);
            if (policy.getErrorHandler() != null) {
                policy.getErrorHandler().accept(ex);
            }
            if (state.delayMillis == 0L) {
                state.delayMillis = policy.getInitialDelay().toMillis();
            }
            Thread.sleep(state.delayMillis);
            state.delayMillis = Math.min((long)((double)state.delayMillis * policy.getDelayMultiplier()), policy.getMaxDelay().toMillis());
            return Result.err((Throwable)ex);
        }
        throw ex;
    }

    private boolean isRetryable(Throwable ex, RetryPolicy policy) {
        return policy.isRetryAll() || Retryer.isNetworkError(ex);
    }

    public static boolean isNetworkError(@NonNull Throwable ex) {
        if (ex == null) {
            throw new NullPointerException("ex");
        }
        if (ex instanceof SocketException) {
            return true;
        }
        if (ex instanceof ShutdownSignalException) {
            return ((ShutdownSignalException)ex).isHardError();
        }
        if (ex.getCause() != null && ex.getCause() != ex) {
            return Retryer.isNetworkError(ex.getCause());
        }
        return false;
    }

    public static boolean shouldReconnectToRecover(@NonNull Throwable ex) {
        if (ex == null) {
            throw new NullPointerException("ex");
        }
        if (Retryer.isNetworkError(ex)) {
            return true;
        }
        if (ex instanceof ShutdownSignalException) {
            return true;
        }
        if (ex.getCause() != null && ex.getCause() != ex) {
            return Retryer.shouldReconnectToRecover(ex.getCause());
        }
        return false;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    private static class RetryState {
        long delayMillis;

        private RetryState() {
        }
    }
}

