/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.hamq;

import java.time.Duration;
import java.util.function.Consumer;

public final class RetryPolicy {
    private final boolean retryAll;
    private final Duration initialDelay;
    private final Duration maxDelay;
    private final double delayMultiplier;
    private final Consumer<Throwable> errorHandler;

    public RetryPolicy() {
        this.retryAll = false;
        this.errorHandler = null;
        this.initialDelay = Duration.ofSeconds(1L);
        this.maxDelay = Duration.ofSeconds(30L);
        this.delayMultiplier = 1.5;
    }

    public boolean isRetryAll() {
        return this.retryAll;
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public double getDelayMultiplier() {
        return this.delayMultiplier;
    }

    public Consumer<Throwable> getErrorHandler() {
        return this.errorHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetryPolicy)) {
            return false;
        }
        RetryPolicy other = (RetryPolicy)o;
        if (this.isRetryAll() != other.isRetryAll()) {
            return false;
        }
        Duration this$initialDelay = this.getInitialDelay();
        Duration other$initialDelay = other.getInitialDelay();
        if (this$initialDelay == null ? other$initialDelay != null : !((Object)this$initialDelay).equals(other$initialDelay)) {
            return false;
        }
        Duration this$maxDelay = this.getMaxDelay();
        Duration other$maxDelay = other.getMaxDelay();
        if (this$maxDelay == null ? other$maxDelay != null : !((Object)this$maxDelay).equals(other$maxDelay)) {
            return false;
        }
        if (Double.compare(this.getDelayMultiplier(), other.getDelayMultiplier()) != 0) {
            return false;
        }
        Consumer<Throwable> this$errorHandler = this.getErrorHandler();
        Consumer<Throwable> other$errorHandler = other.getErrorHandler();
        return !(this$errorHandler == null ? other$errorHandler != null : !this$errorHandler.equals(other$errorHandler));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRetryAll() ? 79 : 97);
        Duration $initialDelay = this.getInitialDelay();
        result = result * 59 + ($initialDelay == null ? 43 : ((Object)$initialDelay).hashCode());
        Duration $maxDelay = this.getMaxDelay();
        result = result * 59 + ($maxDelay == null ? 43 : ((Object)$maxDelay).hashCode());
        long $delayMultiplier = Double.doubleToLongBits(this.getDelayMultiplier());
        result = result * 59 + (int)($delayMultiplier >>> 32 ^ $delayMultiplier);
        Consumer<Throwable> $errorHandler = this.getErrorHandler();
        result = result * 59 + ($errorHandler == null ? 43 : $errorHandler.hashCode());
        return result;
    }

    public String toString() {
        return "RetryPolicy(retryAll=" + this.isRetryAll() + ", initialDelay=" + this.getInitialDelay() + ", maxDelay=" + this.getMaxDelay() + ", delayMultiplier=" + this.getDelayMultiplier() + ", errorHandler=" + this.getErrorHandler() + ")";
    }

    public RetryPolicy withRetryAll(boolean retryAll) {
        return this.retryAll == retryAll ? this : new RetryPolicy(retryAll, this.initialDelay, this.maxDelay, this.delayMultiplier, this.errorHandler);
    }

    public RetryPolicy withInitialDelay(Duration initialDelay) {
        return this.initialDelay == initialDelay ? this : new RetryPolicy(this.retryAll, initialDelay, this.maxDelay, this.delayMultiplier, this.errorHandler);
    }

    public RetryPolicy withMaxDelay(Duration maxDelay) {
        return this.maxDelay == maxDelay ? this : new RetryPolicy(this.retryAll, this.initialDelay, maxDelay, this.delayMultiplier, this.errorHandler);
    }

    public RetryPolicy withDelayMultiplier(double delayMultiplier) {
        return this.delayMultiplier == delayMultiplier ? this : new RetryPolicy(this.retryAll, this.initialDelay, this.maxDelay, delayMultiplier, this.errorHandler);
    }

    private RetryPolicy(boolean retryAll, Duration initialDelay, Duration maxDelay, double delayMultiplier, Consumer<Throwable> errorHandler) {
        this.retryAll = retryAll;
        this.initialDelay = initialDelay;
        this.maxDelay = maxDelay;
        this.delayMultiplier = delayMultiplier;
        this.errorHandler = errorHandler;
    }

    RetryPolicy withErrorHandler(Consumer<Throwable> errorHandler) {
        return this.errorHandler == errorHandler ? this : new RetryPolicy(this.retryAll, this.initialDelay, this.maxDelay, this.delayMultiplier, errorHandler);
    }
}

