/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.hamq;

import io.buybrain.hamq.OperationSpec;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public final class QueueSpec
extends OperationSpec<QueueSpec> {
    @NonNull
    private final String name;
    private final boolean durable;
    private final boolean exclusive;
    private final boolean autoDelete;
    @NonNull
    private final Map<String, Object> args;

    public QueueSpec(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        this.durable = true;
        this.exclusive = false;
        this.autoDelete = false;
        this.args = Collections.emptyMap();
    }

    QueueSpec withArg(@NonNull String name, @NonNull Object value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        HashMap<String, Object> newArgs = new HashMap<String, Object>(this.args);
        newArgs.put(name, value);
        return this.withArgs(newArgs);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    @NonNull
    public Map<String, Object> getArgs() {
        return this.args;
    }

    public String toString() {
        return "QueueSpec(name=" + this.getName() + ", durable=" + this.isDurable() + ", exclusive=" + this.isExclusive() + ", autoDelete=" + this.isAutoDelete() + ", args=" + this.getArgs() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueSpec)) {
            return false;
        }
        QueueSpec other = (QueueSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.isDurable() != other.isDurable()) {
            return false;
        }
        if (this.isExclusive() != other.isExclusive()) {
            return false;
        }
        if (this.isAutoDelete() != other.isAutoDelete()) {
            return false;
        }
        Map<String, Object> this$args = this.getArgs();
        Map<String, Object> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueueSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.isDurable() ? 79 : 97);
        result = result * 59 + (this.isExclusive() ? 79 : 97);
        result = result * 59 + (this.isAutoDelete() ? 79 : 97);
        Map<String, Object> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    public QueueSpec withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.name == name ? this : new QueueSpec(name, this.durable, this.exclusive, this.autoDelete, this.args);
    }

    public QueueSpec withDurable(boolean durable) {
        return this.durable == durable ? this : new QueueSpec(this.name, durable, this.exclusive, this.autoDelete, this.args);
    }

    public QueueSpec withExclusive(boolean exclusive) {
        return this.exclusive == exclusive ? this : new QueueSpec(this.name, this.durable, exclusive, this.autoDelete, this.args);
    }

    public QueueSpec withAutoDelete(boolean autoDelete) {
        return this.autoDelete == autoDelete ? this : new QueueSpec(this.name, this.durable, this.exclusive, autoDelete, this.args);
    }

    public QueueSpec withArgs(@NonNull Map<String, Object> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        return this.args == args ? this : new QueueSpec(this.name, this.durable, this.exclusive, this.autoDelete, args);
    }

    @ConstructorProperties(value={"name", "durable", "exclusive", "autoDelete", "args"})
    public QueueSpec(@NonNull String name, boolean durable, boolean exclusive, boolean autoDelete, @NonNull Map<String, Object> args) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.name = name;
        this.durable = durable;
        this.exclusive = exclusive;
        this.autoDelete = autoDelete;
        this.args = args;
    }
}

