/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.hamq;

import io.buybrain.hamq.OperationSpec;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import lombok.NonNull;

public final class PublishSpec
extends OperationSpec<PublishSpec> {
    @NonNull
    private final String exchange;
    @NonNull
    private final String routingKey;
    private final boolean mandatory;
    private final boolean durable;
    private final byte[] body;

    public PublishSpec(@NonNull String exchange, @NonNull String routingKey, byte[] body) {
        if (exchange == null) {
            throw new NullPointerException("exchange");
        }
        if (routingKey == null) {
            throw new NullPointerException("routingKey");
        }
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.mandatory = false;
        this.durable = true;
        this.body = body;
    }

    public static PublishSpec queue(@NonNull String queueName, byte[] body) {
        if (queueName == null) {
            throw new NullPointerException("queueName");
        }
        return new PublishSpec("", queueName, body);
    }

    @NonNull
    public String getExchange() {
        return this.exchange;
    }

    @NonNull
    public String getRoutingKey() {
        return this.routingKey;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String toString() {
        return "PublishSpec(exchange=" + this.getExchange() + ", routingKey=" + this.getRoutingKey() + ", mandatory=" + this.isMandatory() + ", durable=" + this.isDurable() + ", body=" + Arrays.toString(this.getBody()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublishSpec)) {
            return false;
        }
        PublishSpec other = (PublishSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$exchange = this.getExchange();
        String other$exchange = other.getExchange();
        if (this$exchange == null ? other$exchange != null : !this$exchange.equals(other$exchange)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        if (this.isMandatory() != other.isMandatory()) {
            return false;
        }
        if (this.isDurable() != other.isDurable()) {
            return false;
        }
        return Arrays.equals(this.getBody(), other.getBody());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PublishSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $exchange = this.getExchange();
        result = result * 59 + ($exchange == null ? 43 : $exchange.hashCode());
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        result = result * 59 + (this.isMandatory() ? 79 : 97);
        result = result * 59 + (this.isDurable() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getBody());
        return result;
    }

    public PublishSpec withExchange(@NonNull String exchange) {
        if (exchange == null) {
            throw new NullPointerException("exchange");
        }
        return this.exchange == exchange ? this : new PublishSpec(exchange, this.routingKey, this.mandatory, this.durable, this.body);
    }

    public PublishSpec withRoutingKey(@NonNull String routingKey) {
        if (routingKey == null) {
            throw new NullPointerException("routingKey");
        }
        return this.routingKey == routingKey ? this : new PublishSpec(this.exchange, routingKey, this.mandatory, this.durable, this.body);
    }

    public PublishSpec withMandatory(boolean mandatory) {
        return this.mandatory == mandatory ? this : new PublishSpec(this.exchange, this.routingKey, mandatory, this.durable, this.body);
    }

    public PublishSpec withDurable(boolean durable) {
        return this.durable == durable ? this : new PublishSpec(this.exchange, this.routingKey, this.mandatory, durable, this.body);
    }

    public PublishSpec withBody(byte[] body) {
        return this.body == body ? this : new PublishSpec(this.exchange, this.routingKey, this.mandatory, this.durable, body);
    }

    @ConstructorProperties(value={"exchange", "routingKey", "mandatory", "durable", "body"})
    public PublishSpec(@NonNull String exchange, @NonNull String routingKey, boolean mandatory, boolean durable, byte[] body) {
        if (exchange == null) {
            throw new NullPointerException("exchange");
        }
        if (routingKey == null) {
            throw new NullPointerException("routingKey");
        }
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.mandatory = mandatory;
        this.durable = durable;
        this.body = body;
    }
}

