/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.hamq;

import io.buybrain.hamq.OperationSpec;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public final class ExchangeSpec
extends OperationSpec<ExchangeSpec> {
    @NonNull
    private final String name;
    @NonNull
    private final String type;
    private final boolean durable;
    private final boolean autoDelete;
    private final boolean internal;
    @NonNull
    private final Map<String, Object> args;

    public ExchangeSpec(@NonNull String name, @NonNull String type) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.name = name;
        this.type = type;
        this.durable = true;
        this.autoDelete = false;
        this.internal = false;
        this.args = Collections.emptyMap();
    }

    public ExchangeSpec withArg(@NonNull String name, @NonNull Object value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        HashMap<String, Object> newArgs = new HashMap<String, Object>(this.args);
        newArgs.put(name, value);
        return this.withArgs(newArgs);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public boolean isInternal() {
        return this.internal;
    }

    @NonNull
    public Map<String, Object> getArgs() {
        return this.args;
    }

    public String toString() {
        return "ExchangeSpec(name=" + this.getName() + ", type=" + this.getType() + ", durable=" + this.isDurable() + ", autoDelete=" + this.isAutoDelete() + ", internal=" + this.isInternal() + ", args=" + this.getArgs() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExchangeSpec)) {
            return false;
        }
        ExchangeSpec other = (ExchangeSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (this.isDurable() != other.isDurable()) {
            return false;
        }
        if (this.isAutoDelete() != other.isAutoDelete()) {
            return false;
        }
        if (this.isInternal() != other.isInternal()) {
            return false;
        }
        Map<String, Object> this$args = this.getArgs();
        Map<String, Object> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExchangeSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + (this.isDurable() ? 79 : 97);
        result = result * 59 + (this.isAutoDelete() ? 79 : 97);
        result = result * 59 + (this.isInternal() ? 79 : 97);
        Map<String, Object> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    public ExchangeSpec withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.name == name ? this : new ExchangeSpec(name, this.type, this.durable, this.autoDelete, this.internal, this.args);
    }

    public ExchangeSpec withType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        return this.type == type ? this : new ExchangeSpec(this.name, type, this.durable, this.autoDelete, this.internal, this.args);
    }

    public ExchangeSpec withDurable(boolean durable) {
        return this.durable == durable ? this : new ExchangeSpec(this.name, this.type, durable, this.autoDelete, this.internal, this.args);
    }

    public ExchangeSpec withAutoDelete(boolean autoDelete) {
        return this.autoDelete == autoDelete ? this : new ExchangeSpec(this.name, this.type, this.durable, autoDelete, this.internal, this.args);
    }

    public ExchangeSpec withInternal(boolean internal) {
        return this.internal == internal ? this : new ExchangeSpec(this.name, this.type, this.durable, this.autoDelete, internal, this.args);
    }

    public ExchangeSpec withArgs(@NonNull Map<String, Object> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        return this.args == args ? this : new ExchangeSpec(this.name, this.type, this.durable, this.autoDelete, this.internal, args);
    }

    @ConstructorProperties(value={"name", "type", "durable", "autoDelete", "internal", "args"})
    public ExchangeSpec(@NonNull String name, @NonNull String type, boolean durable, boolean autoDelete, boolean internal, @NonNull Map<String, Object> args) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.name = name;
        this.type = type;
        this.durable = durable;
        this.autoDelete = autoDelete;
        this.internal = internal;
        this.args = args;
    }
}

