/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.hamq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import io.buybrain.hamq.BackendChannel;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;

public final class Delivery {
    private final BackendChannel channel;
    private final Envelope envelope;
    private final AMQP.BasicProperties properties;
    private final byte[] body;

    public String getBodyAsString() {
        return new String(this.body);
    }

    public void ack() throws IOException {
        this.channel.basicAck(this.envelope.getDeliveryTag());
    }

    public void nack() throws IOException {
        this.channel.basicNack(this.envelope.getDeliveryTag());
    }

    @ConstructorProperties(value={"channel", "envelope", "properties", "body"})
    public Delivery(BackendChannel channel, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        this.channel = channel;
        this.envelope = envelope;
        this.properties = properties;
        this.body = body;
    }

    public BackendChannel getChannel() {
        return this.channel;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public AMQP.BasicProperties getProperties() {
        return this.properties;
    }

    public byte[] getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Delivery)) {
            return false;
        }
        Delivery other = (Delivery)o;
        BackendChannel this$channel = this.getChannel();
        BackendChannel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        Envelope this$envelope = this.getEnvelope();
        Envelope other$envelope = other.getEnvelope();
        if (this$envelope == null ? other$envelope != null : !this$envelope.equals(other$envelope)) {
            return false;
        }
        AMQP.BasicProperties this$properties = this.getProperties();
        AMQP.BasicProperties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        return Arrays.equals(this.getBody(), other.getBody());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BackendChannel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        Envelope $envelope = this.getEnvelope();
        result = result * 59 + ($envelope == null ? 43 : $envelope.hashCode());
        AMQP.BasicProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        return result;
    }

    public String toString() {
        return "Delivery(channel=" + this.getChannel() + ", envelope=" + this.getEnvelope() + ", properties=" + this.getProperties() + ", body=" + Arrays.toString(this.getBody()) + ")";
    }
}

