/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.hamq;

import io.buybrain.hamq.Backend;
import io.buybrain.hamq.BackendConnection;
import io.buybrain.hamq.Channel;
import io.buybrain.hamq.Config;
import io.buybrain.hamq.RetryPolicy;
import io.buybrain.hamq.Retryer;
import io.buybrain.util.Result;
import io.buybrain.util.time.Clock;
import java.beans.ConstructorProperties;
import lombok.NonNull;

public class Connection {
    @NonNull
    private final Config config;
    @NonNull
    private final Backend backend;
    private BackendConnection connection;
    private Retryer retryer = new Retryer();

    public void setClock(@NonNull Clock clock) {
        if (clock == null) {
            throw new NullPointerException("clock");
        }
        this.retryer.setClock(clock);
    }

    public Channel createChannel() {
        return new Channel(this, this.retryer);
    }

    public RetryPolicy getRetryPolicy() {
        return this.config.getRetryPolicy();
    }

    synchronized BackendConnection activeConnection() {
        if (this.connection == null) {
            this.connection = (BackendConnection)this.retryer.performWithRetry(() -> this.backend.newConnection(this.config), new RetryPolicy().withRetryAll(true));
        }
        return this.connection;
    }

    synchronized void reset() {
        if (this.connection != null) {
            Result.trying(this.connection::close);
        }
        this.connection = null;
    }

    @ConstructorProperties(value={"config", "backend"})
    public Connection(@NonNull Config config, @NonNull Backend backend) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        if (backend == null) {
            throw new NullPointerException("backend");
        }
        this.config = config;
        this.backend = backend;
    }
}

