/*
 * Decompiled with CFR 0.152.
 */
package io.buybrain.hamq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import io.buybrain.hamq.BackendChannel;
import io.buybrain.util.Exceptions;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import lombok.NonNull;

class AMQPBackendChannel
implements BackendChannel {
    @NonNull
    Channel channel;

    @Override
    public void exchangeDeclare(@NonNull String exchange, @NonNull String type, boolean durable, boolean autoDelete, boolean internal, @NonNull Map<String, Object> arguments) throws IOException {
        if (exchange == null) {
            throw new NullPointerException("exchange");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments");
        }
        this.channel.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
    }

    @Override
    public void queueDeclare(@NonNull String queue, boolean durable, boolean exclusive, boolean autoDelete, @NonNull Map<String, Object> arguments) throws IOException {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments");
        }
        this.channel.queueDeclare(queue, durable, exclusive, autoDelete, arguments);
    }

    @Override
    public void basicQos(int prefetch) throws IOException {
        this.channel.basicQos(prefetch);
    }

    @Override
    public void basicPublish(@NonNull String exchange, @NonNull String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) throws IOException {
        if (exchange == null) {
            throw new NullPointerException("exchange");
        }
        if (routingKey == null) {
            throw new NullPointerException("routingKey");
        }
        this.channel.basicPublish(exchange, routingKey, mandatory, props, body);
    }

    @Override
    public void basicConsume(@NonNull String queue, @NonNull String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback) throws IOException {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        if (consumerTag == null) {
            throw new NullPointerException("consumerTag");
        }
        this.channel.basicConsume(queue, false, consumerTag, noLocal, exclusive, arguments, callback);
    }

    @Override
    public void basicAck(long deliveryTag) throws IOException {
        this.channel.basicAck(deliveryTag, false);
    }

    @Override
    public void basicNack(long deliveryTag) throws IOException {
        this.channel.basicNack(deliveryTag, false, false);
    }

    @Override
    public void basicCancel(@NonNull String consumerTag) throws IOException {
        if (consumerTag == null) {
            throw new NullPointerException("consumerTag");
        }
        this.channel.basicCancel(consumerTag);
    }

    @Override
    public void close() throws IOException {
        Exceptions.rethrow(() -> this.channel.close());
    }

    @ConstructorProperties(value={"channel"})
    public AMQPBackendChannel(@NonNull Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        this.channel = channel;
    }
}

