/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.contrib.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.contrib.function.SubstringMatchingFunction;
import io.burt.jmespath.function.ArgumentConstraint;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.FunctionArgument;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TranslateFunction
extends SubstringMatchingFunction {
    public TranslateFunction() {
        super(ArgumentConstraints.listOf((int)3, (int)3, (ArgumentConstraint)ArgumentConstraints.typeOf((JmesPathType)JmesPathType.STRING)));
    }

    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        String arg = runtime.toString(arguments.get(0).value());
        String map = runtime.toString(arguments.get(1).value());
        String trans = runtime.toString(arguments.get(2).value());
        if (TranslateFunction.isEmpty(arg)) {
            return (T)runtime.createString("");
        }
        return (T)runtime.createString(TranslateFunction.replaceChars(arg, map, trans));
    }

    protected static String replaceChars(String input, String from, String to) {
        StringBuilder sb = new StringBuilder();
        Map<Character, Character> map = TranslateFunction.buildTranslationMap(from, to);
        for (int i = 0; i < input.length(); ++i) {
            Character ch = Character.valueOf(input.charAt(i));
            if (map.containsKey(ch)) {
                Character tr = map.get(ch);
                if (null == tr) continue;
                sb.append(tr);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static Map<Character, Character> buildTranslationMap(String from, String to) {
        HashMap<Character, Character> map = new HashMap<Character, Character>();
        for (int i = 0; i < from.length(); ++i) {
            Character ch = Character.valueOf(from.charAt(i));
            if (map.containsKey(ch)) continue;
            map.put(Character.valueOf(from.charAt(i)), i < to.length() ? Character.valueOf(to.charAt(i)) : null);
        }
        return map;
    }
}

