/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.contrib.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.contrib.function.SubstringMatchingFunction;
import io.burt.jmespath.function.ArgumentConstraint;
import io.burt.jmespath.function.FunctionArgument;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class RegularExpressionFunction
extends SubstringMatchingFunction {
    public RegularExpressionFunction(ArgumentConstraint argumentConstraints) {
        super(argumentConstraints);
    }

    protected <T> String getInputString(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        return this.getStringParam(runtime, arguments, this.inputArgumentPosition());
    }

    protected <T> Pattern getPattern(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        String regex = this.getStringParam(runtime, arguments, this.patternArgumentPosition());
        Pattern pattern = Pattern.compile(regex, this.getFlags(runtime, arguments));
        if (pattern.matcher("").matches()) {
            throw new PatternSyntaxException("pattern matches zero-length string", pattern.pattern(), -1);
        }
        return pattern;
    }

    protected <T> int getFlags(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        if (arguments.size() <= this.flagArgumentPosition()) {
            return 0;
        }
        return this.convertPatternFlags(this.getStringParam(runtime, arguments, this.flagArgumentPosition()));
    }

    protected <T> String getStringParam(Adapter<T> runtime, List<FunctionArgument<T>> arguments, int i) {
        return runtime.toString(arguments.get(i).value());
    }

    protected int inputArgumentPosition() {
        return 0;
    }

    protected int patternArgumentPosition() {
        return 1;
    }

    protected int flagArgumentPosition() {
        return 2;
    }

    private int convertPatternFlags(String flagStr) {
        int flags = 0;
        block7: for (int i = 0; i < flagStr.length(); ++i) {
            char c = flagStr.charAt(i);
            switch (c) {
                case 's': {
                    flags |= 0x20;
                    continue block7;
                }
                case 'm': {
                    flags |= 8;
                    continue block7;
                }
                case 'i': {
                    flags |= 0x42;
                    continue block7;
                }
                case 'x': {
                    flags |= 4;
                    continue block7;
                }
                case 'q': {
                    flags |= 0x10;
                    continue block7;
                }
                default: {
                    throw new InvalidRegexFlagException(c, flagStr);
                }
            }
        }
        return flags;
    }

    private class InvalidRegexFlagException
    extends RuntimeException {
        private final char unknownFlag;
        private final String flagStr;

        public InvalidRegexFlagException(char flag, String flagStr) {
            this.unknownFlag = flag;
            this.flagStr = flagStr;
        }

        public char getUnknownFlag() {
            return this.unknownFlag;
        }

        public String getFlagStr() {
            return this.flagStr;
        }

        @Override
        public String toString() {
            return "Unknown regex flag: " + this.getUnknownFlag() + " in " + this.getFlagStr();
        }
    }
}

