/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.contrib.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraint;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.FunctionArgument;
import java.util.List;

public class ConcatFunction
extends BaseFunction {
    public ConcatFunction() {
        super(ArgumentConstraints.listOf((int)2, (ArgumentConstraint)ArgumentConstraints.anyValue()));
    }

    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        StringBuilder sb = new StringBuilder();
        for (FunctionArgument<T> arg : arguments) {
            Object value = arg.value();
            if (runtime.typeOf(value) == JmesPathType.NULL) continue;
            sb.append(runtime.toString(value));
        }
        return (T)runtime.createString(sb.toString());
    }
}

