/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.result.s3;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class InputStreamResponseTransformer
extends InputStream
implements AsyncResponseTransformer<GetObjectResponse, InputStream>,
Subscriber<ByteBuffer> {
    private static final ByteBuffer END_MARKER = ByteBuffer.allocate(0);
    private static int TARGET_BUFFER_SIZE = 0x2000000;
    private final CompletableFuture<InputStream> future = new CompletableFuture();
    private final BlockingQueue<ByteBuffer> chunks = new LinkedBlockingQueue<ByteBuffer>();
    private GetObjectResponse response;
    private Subscription subscription;
    private ByteBuffer readChunk;
    private Throwable error;
    private AtomicBoolean complete = new AtomicBoolean(false);
    private AtomicInteger approximateBufferSize = new AtomicInteger(0);

    public CompletableFuture<InputStream> prepare() {
        return this.future;
    }

    public void onResponse(GetObjectResponse r) {
        this.response = r;
        this.future.complete(this);
    }

    public void onStream(SdkPublisher<ByteBuffer> publisher) {
        publisher.subscribe((Subscriber)this);
    }

    public void exceptionOccurred(Throwable t) {
        this.error = t;
        this.future.completeExceptionally(t);
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        if (this.response.contentLength() < (long)TARGET_BUFFER_SIZE) {
            this.subscription.request(Long.MAX_VALUE);
        } else {
            this.subscription.request(10L);
        }
    }

    public void onNext(ByteBuffer byteBuffer) {
        if (byteBuffer.hasRemaining()) {
            this.chunks.offer(byteBuffer);
        }
        int size = this.approximateBufferSize.addAndGet(byteBuffer.remaining());
        this.maybeRequestMore(size);
    }

    private void maybeRequestMore(int currentSize) {
        if (currentSize < TARGET_BUFFER_SIZE) {
            this.subscription.request(10L);
        }
    }

    public void onError(Throwable t) {
        this.exceptionOccurred(t);
    }

    public void onComplete() {
        this.chunks.offer(END_MARKER);
        this.complete.set(true);
    }

    @Override
    public int available() throws IOException {
        if (this.error != null) {
            throw new IOException(this.error);
        }
        if (this.readChunk != null) {
            return this.readChunk.remaining();
        }
        return 0;
    }

    private boolean ensureChunk() throws IOException {
        if (this.error != null) {
            throw new IOException(this.error);
        }
        if (this.readChunk == END_MARKER) {
            return false;
        }
        if (this.readChunk == null || !this.readChunk.hasRemaining()) {
            try {
                this.readChunk = this.chunks.take();
                if (this.readChunk == END_MARKER) {
                    return false;
                }
                int size = this.approximateBufferSize.addAndGet(-this.readChunk.remaining());
                this.maybeRequestMore(size);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        return true;
    }

    @Override
    public int read(byte[] destination, int offset, int length) throws IOException {
        if (this.ensureChunk()) {
            int actualLength = Math.min(length, this.readChunk.remaining());
            this.readChunk.get(destination, offset, actualLength);
            return actualLength;
        }
        return -1;
    }

    @Override
    public int read() throws IOException {
        if (this.ensureChunk()) {
            return Byte.toUnsignedInt(this.readChunk.get());
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        if (!this.complete.get()) {
            this.chunks.clear();
            this.chunks.offer(END_MARKER);
            this.subscription.cancel();
            this.future.cancel(true);
        }
        super.close();
    }
}

