/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.result.s3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class ByteBufferResponseTransformer
implements AsyncResponseTransformer<GetObjectResponse, ByteBuffer>,
Subscriber<ByteBuffer> {
    private final CompletableFuture<ByteBuffer> future = new CompletableFuture();
    private Subscription subscription;
    private ByteBuffer resultBuffer;

    public CompletableFuture<ByteBuffer> prepare() {
        return this.future;
    }

    public void onResponse(GetObjectResponse response) {
        this.resultBuffer = ByteBuffer.allocate(Math.toIntExact(response.contentLength()));
    }

    public void onStream(SdkPublisher<ByteBuffer> publisher) {
        publisher.subscribe((Subscriber)this);
    }

    public void exceptionOccurred(Throwable t) {
        this.future.completeExceptionally(t);
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        this.subscription.request(Long.MAX_VALUE);
    }

    public void onNext(ByteBuffer byteBuffer) {
        this.resultBuffer.put(byteBuffer);
        this.subscription.request(Long.MAX_VALUE);
    }

    public void onError(Throwable t) {
        this.exceptionOccurred(t);
    }

    public void onComplete() {
        ((Buffer)this.resultBuffer).flip();
        this.future.complete(this.resultBuffer);
    }
}

