/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.result.protobuf;

import io.burt.athena.result.protobuf.BinaryField;
import io.burt.athena.result.protobuf.Field;
import io.burt.athena.result.protobuf.IntegerField;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import software.amazon.awssdk.utils.IoUtils;

public class VeryBasicProtobufParser {
    public List<Field> parse(InputStream input) throws IOException {
        return this.parse(IoUtils.toByteArray((InputStream)input));
    }

    public List<Field> parse(byte[] bytes) {
        return this.parse(ByteBuffer.wrap(bytes));
    }

    public List<Field> parse(ByteBuffer buffer) {
        LinkedList<Field> fields = new LinkedList<Field>();
        while (buffer.hasRemaining()) {
            fields.add(this.readField(buffer));
        }
        return fields;
    }

    private Field readField(ByteBuffer buffer) {
        int x = Byte.toUnsignedInt(buffer.get());
        int fieldNumber = x >> 3;
        int fieldType = x & 7;
        switch (fieldType) {
            case 0: {
                long value = this.readVarint(buffer);
                return new IntegerField(fieldNumber, value);
            }
            case 2: {
                byte[] contents = this.readLengthDelimited(buffer);
                return new BinaryField(fieldNumber, contents);
            }
        }
        throw new IllegalStateException(String.format("Unsupported field type: %d", fieldType));
    }

    private byte[] readLengthDelimited(ByteBuffer buffer) {
        int size = Math.toIntExact(this.readVarint(buffer));
        byte[] contents = new byte[size];
        buffer.get(contents);
        return contents;
    }

    private long readVarint(ByteBuffer buffer) {
        int b = Byte.toUnsignedInt(buffer.get());
        int n = b & 0x7F;
        int i = 1;
        while ((b & 0x80) != 0) {
            b = Byte.toUnsignedInt(buffer.get());
            n |= (b & 0x7F) << i * 7;
            ++i;
        }
        return n;
    }
}

