/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.result.csv;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Iterator;

public class VeryBasicCsvParser
implements Iterator<String[]> {
    private final Reader csv;
    private final int columnCount;
    private String[] nextRow;
    private int nextChar0;
    private int nextChar1;
    private int position;

    public VeryBasicCsvParser(Reader csv, int columnCount) {
        this.csv = csv;
        this.columnCount = columnCount;
        this.nextRow = null;
        this.nextChar0 = -1;
        this.nextChar1 = -1;
        this.position = -1;
    }

    @Override
    public String[] next() {
        if (this.nextRow == null) {
            this.loadNext();
        }
        String[] n = this.nextRow;
        this.nextRow = null;
        return n;
    }

    private boolean loadNext() {
        try {
            if (this.nextChar0 == -1) {
                this.advance();
            }
            if (this.nextChar0 == -1) {
                return false;
            }
            this.nextRow = new String[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.nextChar0 == 44 || this.nextChar0 == 10) {
                    this.advance();
                    this.nextRow[i] = null;
                    continue;
                }
                this.consumeQuote();
                this.nextRow[i] = this.consumeString();
                this.consumeQuote();
                if (i == this.columnCount - 1) {
                    this.consumeNewline();
                    continue;
                }
                this.consumeComma();
            }
            return true;
        }
        catch (IOException | ParseException e) {
            this.nextRow = null;
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextRow != null || this.loadNext();
    }

    private void advance() throws IOException {
        this.nextChar0 = this.nextChar0 == -1 ? this.csv.read() : this.nextChar1;
        this.nextChar1 = this.csv.read();
        ++this.position;
    }

    private String charToString(int chr) {
        if (chr == 10) {
            return "\\n";
        }
        return String.format("%c", chr);
    }

    private void consumeQuote() throws IOException, ParseException {
        if (this.nextChar0 != 34) {
            throw new ParseException(String.format("Expected quote but found \"%s\"", this.charToString(this.nextChar0)), this.position);
        }
        this.advance();
    }

    private void consumeComma() throws IOException, ParseException {
        if (this.nextChar0 != 44) {
            throw new ParseException(String.format("Expected comma but found \"%s\"", this.charToString(this.nextChar0)), this.position);
        }
        this.advance();
    }

    private void consumeNewline() throws IOException, ParseException {
        if (this.nextChar0 != 10) {
            throw new ParseException(String.format("Expected newline but found \"%s\"", this.charToString(this.nextChar0)), this.position);
        }
        this.advance();
    }

    private String consumeString() throws IOException, ParseException {
        StringBuilder builder = new StringBuilder();
        while (this.nextChar0 != 34 || this.nextChar1 == 34) {
            if (this.nextChar0 == -1) {
                throw new ParseException("Unexpected end of stream", this.position);
            }
            if (this.nextChar0 == 34) {
                this.advance();
            }
            builder.appendCodePoint(this.nextChar0);
            this.advance();
        }
        return builder.toString();
    }
}

