/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.result;

import io.burt.athena.AthenaResultSetMetaData;
import io.burt.athena.result.Result;
import io.burt.athena.result.ResultPosition;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.Datum;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athena.model.Row;

public class StandardResult
implements Result {
    public static final int MAX_FETCH_SIZE = 1000;
    private int fetchSize;
    protected final QueryExecution queryExecution;
    protected final AthenaAsyncClient athenaClient;
    protected final Duration timeout;
    protected Iterator<Row> currentRows;
    protected Row currentRow;
    private AthenaResultSetMetaData resultSetMetaData;
    private String nextToken;
    private int rowNumber;

    public StandardResult(AthenaAsyncClient athenaClient, QueryExecution queryExecution, int fetchSize, Duration timeout) {
        this.athenaClient = athenaClient;
        this.queryExecution = queryExecution;
        this.fetchSize = fetchSize;
        this.timeout = timeout;
        this.rowNumber = 0;
        this.nextToken = null;
        this.currentRows = null;
        this.currentRow = null;
        this.resultSetMetaData = null;
    }

    private void ensureResults() throws SQLException, InterruptedException {
        if (this.shouldLoadNextPage()) {
            try {
                GetQueryResultsResponse response = this.loadNextPage();
                this.nextToken = response.nextToken();
                this.resultSetMetaData = new AthenaResultSetMetaData(this.queryExecution, response.resultSet().resultSetMetadata());
                this.currentRows = response.resultSet().rows().iterator();
                if (this.rowNumber == 0 && this.currentRows.hasNext()) {
                    this.currentRows.next();
                }
            }
            catch (TimeoutException ie) {
                throw new SQLTimeoutException(ie);
            }
            catch (ExecutionException ee) {
                SQLException eee = new SQLException(ee.getCause());
                eee.addSuppressed(ee);
                throw eee;
            }
        }
    }

    protected boolean shouldLoadNextPage() throws SQLException {
        return this.getRowNumber() == 0 && this.currentRows == null || this.nextToken != null && !this.currentRows.hasNext();
    }

    protected GetQueryResultsResponse loadNextPage() throws InterruptedException, TimeoutException, ExecutionException {
        return this.loadPage().get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    protected CompletableFuture<GetQueryResultsResponse> loadPage() {
        return this.loadPage(this.nextToken);
    }

    protected CompletableFuture<GetQueryResultsResponse> loadPage(String nextToken) {
        return this.athenaClient.getQueryResults(builder -> {
            builder.nextToken(nextToken);
            builder.queryExecutionId(this.queryExecution.queryExecutionId());
            builder.maxResults(Integer.valueOf(this.fetchSize));
        });
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int newFetchSize) throws SQLException {
        if (newFetchSize > 1000) {
            throw new SQLException(String.format("Fetch size too large (got %d, max is %d)", newFetchSize, 1000));
        }
        this.fetchSize = newFetchSize;
    }

    @Override
    public AthenaResultSetMetaData getMetaData() throws SQLException {
        if (this.resultSetMetaData == null) {
            try {
                this.ensureResults();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new SQLException(ie);
            }
        }
        return this.resultSetMetaData;
    }

    @Override
    public int getRowNumber() throws SQLException {
        return this.rowNumber;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            this.ensureResults();
            ++this.rowNumber;
            this.currentRow = this.currentRows.hasNext() ? this.currentRows.next() : null;
            return this.currentRow != null;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new SQLException(ie);
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return ((Datum)this.currentRow.data().get(columnIndex - 1)).varCharValue();
    }

    @Override
    public ResultPosition getPosition() throws SQLException {
        if (this.getRowNumber() == 0) {
            return ResultPosition.BEFORE_FIRST;
        }
        if (this.getRowNumber() == 1) {
            return ResultPosition.FIRST;
        }
        if (this.nextToken == null && this.currentRows != null && this.currentRow != null && !this.currentRows.hasNext()) {
            return ResultPosition.LAST;
        }
        if (this.nextToken == null && this.currentRows != null && this.currentRow == null) {
            return ResultPosition.AFTER_LAST;
        }
        return ResultPosition.MIDDLE;
    }

    @Override
    public void close() {
        this.currentRows = null;
        this.currentRow = null;
    }
}

