/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.result;

import io.burt.athena.AthenaResultSetMetaData;
import io.burt.athena.result.AthenaMetaDataParser;
import io.burt.athena.result.Result;
import io.burt.athena.result.ResultPosition;
import io.burt.athena.result.csv.VeryBasicCsvParser;
import io.burt.athena.result.s3.ByteBufferResponseTransformer;
import io.burt.athena.result.s3.InputStreamResponseTransformer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

public class S3Result
implements Result {
    private static final Pattern S3_URI_PATTERN = Pattern.compile("^s3://([^/]+)/(.+)$");
    private final QueryExecution queryExecution;
    private final S3AsyncClient s3Client;
    private final String bucketName;
    private final String key;
    private final Duration timeout;
    private ResponseParser responseParser;
    private String[] currentRow;
    private int rowNumber;

    public S3Result(S3AsyncClient s3Client, QueryExecution queryExecution, Duration timeout) {
        this.s3Client = s3Client;
        this.queryExecution = queryExecution;
        this.timeout = timeout;
        this.currentRow = null;
        this.rowNumber = 0;
        Matcher matcher = S3_URI_PATTERN.matcher(queryExecution.resultConfiguration().outputLocation());
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("The output location \"%s\" is malformed", queryExecution.resultConfiguration().outputLocation()));
        }
        this.bucketName = matcher.group(1);
        this.key = matcher.group(2);
    }

    @Override
    public int getFetchSize() {
        return -1;
    }

    @Override
    public void setFetchSize(int newFetchSize) {
    }

    private void start() throws SQLException, InterruptedException {
        try {
            AthenaMetaDataParser metaDataParser = new AthenaMetaDataParser(this.queryExecution);
            CompletionStage metadataFuture = this.s3Client.getObject(b -> b.bucket(this.bucketName).key(this.key + ".metadata"), (AsyncResponseTransformer)new ByteBufferResponseTransformer()).thenApply(metaDataParser::parse);
            CompletableFuture responseStreamFuture = this.s3Client.getObject(b -> b.bucket(this.bucketName).key(this.key), (AsyncResponseTransformer)new InputStreamResponseTransformer());
            CompletionStage combinedFuture = ((CompletableFuture)metadataFuture).thenCombine((CompletionStage)responseStreamFuture, (metaData, responseStream) -> new ResponseParser((InputStream)responseStream, (AthenaResultSetMetaData)metaData));
            this.responseParser = (ResponseParser)((CompletableFuture)combinedFuture).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
            this.responseParser.next();
            this.rowNumber = 0;
        }
        catch (ExecutionException e) {
            SQLException ee = new SQLException(e.getCause());
            ee.addSuppressed(e);
            throw ee;
        }
        catch (TimeoutException | NoSuchKeyException e) {
            throw new SQLTimeoutException(e);
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof RuntimeException)) {
                SQLException ee = new SQLException(e.getCause());
                ee.addSuppressed(e);
                throw ee;
            }
            throw e;
        }
    }

    @Override
    public AthenaResultSetMetaData getMetaData() throws SQLException {
        if (this.responseParser == null) {
            try {
                this.start();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException(e);
            }
        }
        return this.responseParser.getMetaData();
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.responseParser == null) {
            try {
                this.start();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException(e);
            }
        }
        this.currentRow = this.responseParser.next();
        if (this.currentRow == null) {
            return false;
        }
        ++this.rowNumber;
        return true;
    }

    @Override
    public String getString(int columnIndex) {
        return this.currentRow[columnIndex - 1];
    }

    @Override
    public ResultPosition getPosition() {
        if (this.getRowNumber() == 0) {
            return ResultPosition.BEFORE_FIRST;
        }
        if (this.getRowNumber() == 1) {
            return ResultPosition.FIRST;
        }
        if (this.responseParser.hasNext()) {
            return ResultPosition.MIDDLE;
        }
        if (this.currentRow == null) {
            return ResultPosition.AFTER_LAST;
        }
        return ResultPosition.LAST;
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.responseParser != null) {
                this.responseParser.close();
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private static class ResponseParser
    extends VeryBasicCsvParser
    implements AutoCloseable {
        private final InputStream responseStream;
        private final AthenaResultSetMetaData metaData;

        ResponseParser(InputStream responseStream, AthenaResultSetMetaData metaData) {
            super(new BufferedReader(new InputStreamReader(responseStream)), metaData.getColumnCount());
            this.responseStream = responseStream;
            this.metaData = metaData;
        }

        AthenaResultSetMetaData getMetaData() {
            return this.metaData;
        }

        @Override
        public void close() throws IOException {
            this.responseStream.close();
        }
    }
}

