/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.result;

import io.burt.athena.result.ResultPosition;
import io.burt.athena.result.StandardResult;
import java.sql.SQLException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.QueryExecution;

public class PreloadingStandardResult
extends StandardResult {
    private CompletableFuture<GetQueryResultsResponse> pendingResult = null;

    public PreloadingStandardResult(AthenaAsyncClient athenaClient, QueryExecution queryExecution, int fetchSize, Duration timeout) {
        super(athenaClient, queryExecution, fetchSize, timeout);
    }

    @Override
    protected boolean shouldLoadNextPage() throws SQLException {
        return this.getRowNumber() == 0 && this.currentRows == null || this.pendingResult != null && !this.currentRows.hasNext();
    }

    @Override
    protected GetQueryResultsResponse loadNextPage() throws InterruptedException, TimeoutException, ExecutionException {
        CompletableFuture<GetQueryResultsResponse> loadingPage;
        if (this.pendingResult == null) {
            loadingPage = this.loadPage();
        } else {
            loadingPage = this.pendingResult;
            this.pendingResult = null;
        }
        GetQueryResultsResponse response = loadingPage.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        if (response.nextToken() != null) {
            this.pendingResult = this.loadPage(response.nextToken());
        }
        return response;
    }

    @Override
    public ResultPosition getPosition() throws SQLException {
        if (this.pendingResult == null && this.currentRows != null && this.currentRow != null && !this.currentRows.hasNext()) {
            return ResultPosition.LAST;
        }
        if (this.pendingResult == null && this.currentRows != null && this.currentRow == null) {
            return ResultPosition.AFTER_LAST;
        }
        return super.getPosition();
    }
}

