/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.result;

import io.burt.athena.AthenaResultSetMetaData;
import io.burt.athena.result.protobuf.BinaryField;
import io.burt.athena.result.protobuf.Field;
import io.burt.athena.result.protobuf.IntegerField;
import io.burt.athena.result.protobuf.VeryBasicProtobufParser;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;

public class AthenaMetaDataParser {
    private static final int COLUMNS_FIELD = 4;
    private static final int CATALOG_NAME_FIELD = 1;
    private static final int NAME_FIELD = 4;
    private static final int LABEL_FIELD = 5;
    private static final int TYPE_FIELD = 6;
    private static final int PRECISION_FIELD = 7;
    private static final int SCALE_FIELD = 8;
    private static final int NULLABLE_FIELD = 9;
    private static final int CASE_SENSITIVE_FIELD = 10;
    private final QueryExecution queryExecution;

    public AthenaMetaDataParser(QueryExecution queryExecution) {
        this.queryExecution = queryExecution;
    }

    public AthenaResultSetMetaData parse(ByteBuffer buffer) {
        VeryBasicProtobufParser parser = new VeryBasicProtobufParser();
        List<Field> fields = parser.parse(buffer);
        LinkedList<ColumnInfo> columns = new LinkedList<ColumnInfo>();
        for (Field field : fields) {
            if (field.getNumber() != 4) continue;
            byte[] contents = ((BinaryField)field).getContents();
            List<Field> parse = parser.parse(contents);
            ColumnInfo columnInfo = this.fieldsToColumn(parse);
            columns.add(columnInfo);
        }
        return new AthenaResultSetMetaData(this.queryExecution, (ResultSetMetadata)ResultSetMetadata.builder().columnInfo(columns).build());
    }

    private String fieldToString(Field field) {
        return new String(((BinaryField)field).getContents(), StandardCharsets.UTF_8);
    }

    private int fieldToInt(Field field) {
        return (int)((IntegerField)field).getValue();
    }

    private ColumnInfo fieldsToColumn(List<Field> fields) {
        ColumnInfo.Builder builder = ColumnInfo.builder();
        for (Field field : fields) {
            switch (field.getNumber()) {
                case 1: {
                    builder.catalogName(this.fieldToString(field));
                    break;
                }
                case 4: {
                    builder.name(this.fieldToString(field));
                    break;
                }
                case 5: {
                    builder.label(this.fieldToString(field));
                    break;
                }
                case 6: {
                    builder.type(this.fieldToString(field));
                    break;
                }
                case 7: {
                    builder.precision(Integer.valueOf(this.fieldToInt(field)));
                    break;
                }
                case 8: {
                    builder.scale(Integer.valueOf(this.fieldToInt(field)));
                    break;
                }
                case 9: {
                    int v = this.fieldToInt(field);
                    if (v == 1) {
                        builder.nullable(ColumnNullable.NOT_NULL);
                        break;
                    }
                    if (v == 2) {
                        builder.nullable(ColumnNullable.NULLABLE);
                        break;
                    }
                    builder.nullable(ColumnNullable.UNKNOWN);
                    break;
                }
                case 10: {
                    builder.caseSensitive(Boolean.valueOf(this.fieldToInt(field) == 1));
                }
            }
        }
        return (ColumnInfo)builder.build();
    }
}

