/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.polling;

import io.burt.athena.polling.PollingCallback;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public interface PollingStrategy {
    public ResultSet pollUntilCompleted(PollingCallback var1, Instant var2) throws SQLException, TimeoutException, ExecutionException, InterruptedException;

    default public Duration sleepDuration(Duration desired, Instant now, Instant deadline) throws TimeoutException {
        Duration beforeDeadline = Duration.between(now, deadline);
        if (beforeDeadline.compareTo(desired) < 0) {
            if (beforeDeadline.isNegative()) {
                throw new TimeoutException("polling reached deadline");
            }
            return beforeDeadline;
        }
        return desired;
    }
}

