/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.polling;

import io.burt.athena.polling.BackoffPollingStrategy;
import io.burt.athena.polling.FixedDelayPollingStrategy;
import io.burt.athena.polling.PollingStrategy;
import java.time.Duration;

public class PollingStrategies {
    public static PollingStrategy defaultFixedDelay() {
        return PollingStrategies.fixedDelay(Duration.ofMillis(100L));
    }

    public static PollingStrategy fixedDelay(Duration delay) {
        return new FixedDelayPollingStrategy(delay);
    }

    public static PollingStrategy backoff(Duration firstDelay, Duration maxDelay) {
        return new BackoffPollingStrategy(firstDelay, maxDelay);
    }

    public static PollingStrategy backoff(Duration firstDelay, Duration maxDelay, long factor) {
        return new BackoffPollingStrategy(firstDelay, maxDelay, factor);
    }
}

