/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.polling;

import io.burt.athena.polling.PollingCallback;
import io.burt.athena.polling.PollingStrategy;
import io.burt.athena.polling.Sleeper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FixedDelayPollingStrategy
implements PollingStrategy {
    private final Duration delay;
    private final Sleeper sleeper;
    private Clock clock;

    FixedDelayPollingStrategy(Duration delay) {
        this(delay, duration -> TimeUnit.MILLISECONDS.sleep(duration.toMillis()), Clock.systemDefaultZone());
    }

    FixedDelayPollingStrategy(Duration delay, Sleeper sleeper, Clock clock) {
        this.delay = delay;
        this.sleeper = sleeper;
        this.clock = clock;
    }

    @Override
    public ResultSet pollUntilCompleted(PollingCallback callback, Instant deadline) throws SQLException, TimeoutException, ExecutionException, InterruptedException {
        Optional<ResultSet> resultSet;
        while (!(resultSet = callback.poll(deadline)).isPresent()) {
            this.sleeper.sleep(this.sleepDuration(this.delay, this.clock.instant(), deadline));
        }
        return resultSet.get();
    }
}

