/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena.configuration;

import io.burt.athena.configuration.ConnectionConfiguration;
import io.burt.athena.configuration.ResultLoadingStrategy;
import io.burt.athena.polling.PollingStrategies;
import io.burt.athena.polling.PollingStrategy;
import io.burt.athena.result.PreloadingStandardResult;
import io.burt.athena.result.Result;
import io.burt.athena.result.S3Result;
import java.time.Duration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.AthenaAsyncClientBuilder;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;

class ConcreteConnectionConfiguration
implements ConnectionConfiguration {
    private final Region awsRegion;
    private final String databaseName;
    private final String workGroupName;
    private final String outputLocation;
    private final Duration networkTimeout;
    private final Duration queryTimeout;
    private final ResultLoadingStrategy resultLoadingStrategy;
    private AthenaAsyncClient athenaClient;
    private S3AsyncClient s3Client;
    private PollingStrategy pollingStrategy;

    ConcreteConnectionConfiguration(Region awsRegion, String databaseName, String workGroupName, String outputLocation, Duration networkTimeout, Duration queryTimeout, ResultLoadingStrategy resultLoadingStrategy) {
        this.awsRegion = awsRegion;
        this.databaseName = databaseName;
        this.workGroupName = workGroupName;
        this.outputLocation = outputLocation;
        this.networkTimeout = networkTimeout;
        this.queryTimeout = queryTimeout;
        this.resultLoadingStrategy = resultLoadingStrategy;
    }

    private ConcreteConnectionConfiguration(Region awsRegion, String databaseName, String workGroupName, String outputLocation, Duration networkTimeout, Duration queryTimeout, ResultLoadingStrategy resultLoadingStrategy, AthenaAsyncClient athenaClient, S3AsyncClient s3Client, PollingStrategy pollingStrategy) {
        this(awsRegion, databaseName, workGroupName, outputLocation, networkTimeout, queryTimeout, resultLoadingStrategy);
        this.athenaClient = athenaClient;
        this.s3Client = s3Client;
        this.pollingStrategy = pollingStrategy;
    }

    @Override
    public String databaseName() {
        return this.databaseName;
    }

    @Override
    public String workGroupName() {
        return this.workGroupName;
    }

    @Override
    public String outputLocation() {
        return this.outputLocation;
    }

    @Override
    public Duration networkTimeout() {
        return this.networkTimeout;
    }

    @Override
    public Duration queryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public AthenaAsyncClient athenaClient() {
        if (this.athenaClient == null) {
            this.athenaClient = (AthenaAsyncClient)((AthenaAsyncClientBuilder)AthenaAsyncClient.builder().region(this.awsRegion)).build();
        }
        return this.athenaClient;
    }

    @Override
    public S3AsyncClient s3Client() {
        if (this.s3Client == null) {
            this.s3Client = (S3AsyncClient)((S3AsyncClientBuilder)S3AsyncClient.builder().region(this.awsRegion)).build();
        }
        return this.s3Client;
    }

    @Override
    public PollingStrategy pollingStrategy() {
        if (this.pollingStrategy == null) {
            this.pollingStrategy = PollingStrategies.backoff(Duration.ofMillis(10L), Duration.ofSeconds(5L));
        }
        return this.pollingStrategy;
    }

    @Override
    public ConnectionConfiguration withDatabaseName(String databaseName) {
        return new ConcreteConnectionConfiguration(this.awsRegion, databaseName, this.workGroupName, this.outputLocation, this.networkTimeout, this.queryTimeout, this.resultLoadingStrategy, this.athenaClient, this.s3Client, this.pollingStrategy);
    }

    @Override
    public ConnectionConfiguration withNetworkTimeout(Duration networkTimeout) {
        return new ConcreteConnectionConfiguration(this.awsRegion, this.databaseName, this.workGroupName, this.outputLocation, networkTimeout, this.queryTimeout, this.resultLoadingStrategy, this.athenaClient, this.s3Client, this.pollingStrategy);
    }

    @Override
    public ConnectionConfiguration withQueryTimeout(Duration queryTimeout) {
        return new ConcreteConnectionConfiguration(this.awsRegion, this.databaseName, this.workGroupName, this.outputLocation, this.networkTimeout, queryTimeout, this.resultLoadingStrategy, this.athenaClient, this.s3Client, this.pollingStrategy);
    }

    @Override
    public Result createResult(QueryExecution queryExecution) {
        if (this.resultLoadingStrategy == ResultLoadingStrategy.GET_EXECUTION_RESULTS) {
            return new PreloadingStandardResult(this.athenaClient(), queryExecution, 1000, Duration.ofSeconds(10L));
        }
        if (this.resultLoadingStrategy == ResultLoadingStrategy.S3) {
            return new S3Result(this.s3Client(), queryExecution, Duration.ofSeconds(10L));
        }
        throw new IllegalStateException(String.format("No such result loading strategy: %s", queryExecution));
    }

    @Override
    public void close() {
        if (this.athenaClient != null) {
            this.athenaClient.close();
            this.athenaClient = null;
        }
        if (this.s3Client != null) {
            this.s3Client.close();
            this.s3Client = null;
        }
    }
}

