/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena;

import io.burt.athena.AthenaResultSet;
import io.burt.athena.configuration.ConnectionConfiguration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse;

public class AthenaStatement
implements Statement {
    private final AthenaAsyncClient athenaClient;
    private Clock clock;
    private ConnectionConfiguration configuration;
    private String queryExecutionId;
    private ResultSet currentResultSet;
    private Function<String, Optional<String>> clientRequestTokenProvider;
    private boolean open;

    AthenaStatement(ConnectionConfiguration configuration, Clock clock) {
        this.configuration = configuration;
        this.athenaClient = configuration.athenaClient();
        this.clock = clock;
        this.queryExecutionId = null;
        this.currentResultSet = null;
        this.clientRequestTokenProvider = sql -> Optional.empty();
        this.open = true;
    }

    public void setClientRequestTokenProvider(Function<String, Optional<String>> provider) {
        this.clientRequestTokenProvider = provider == null ? sql -> Optional.empty() : provider;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql);
        return this.getResultSet();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
            this.currentResultSet = null;
        }
        try {
            Instant deadline = this.clock.instant().plus(this.configuration.queryTimeout());
            this.queryExecutionId = this.startQueryExecution(sql, deadline);
            this.currentResultSet = this.configuration.pollingStrategy().pollUntilCompleted(this::poll, deadline);
            return this.currentResultSet != null;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new SQLException(ie);
        }
        catch (TimeoutException te) {
            SQLTimeoutException ste = new SQLTimeoutException(te);
            if (this.queryExecutionId != null) {
                try {
                    this.athenaClient.stopQueryExecution(b -> b.queryExecutionId(this.queryExecutionId));
                }
                catch (Exception e) {
                    ste.addSuppressed(e);
                }
            }
            throw ste;
        }
        catch (ExecutionException ee) {
            SQLException eee = new SQLException(ee.getCause());
            eee.addSuppressed(ee);
            throw eee;
        }
    }

    private String startQueryExecution(String sql, Instant deadline) throws InterruptedException, ExecutionException, TimeoutException {
        return ((StartQueryExecutionResponse)this.athenaClient.startQueryExecution(b -> {
            b.queryString(sql);
            b.workGroup(this.configuration.workGroupName());
            b.queryExecutionContext(bb -> bb.database(this.configuration.databaseName()));
            b.resultConfiguration(bb -> bb.outputLocation(this.configuration.outputLocation()));
            this.clientRequestTokenProvider.apply(sql).ifPresent(arg_0 -> ((StartQueryExecutionRequest.Builder)b).clientRequestToken(arg_0));
        }).get(this.networkTimeoutMillis(deadline), TimeUnit.MILLISECONDS)).queryExecutionId();
    }

    private Optional<ResultSet> poll(Instant deadline) throws SQLException, InterruptedException, ExecutionException, TimeoutException {
        QueryExecution queryExecution = ((GetQueryExecutionResponse)this.athenaClient.getQueryExecution(b -> b.queryExecutionId(this.queryExecutionId)).get(this.networkTimeoutMillis(deadline), TimeUnit.MILLISECONDS)).queryExecution();
        switch (queryExecution.status().state()) {
            case SUCCEEDED: {
                return Optional.of(this.createResultSet(queryExecution));
            }
            case FAILED: 
            case CANCELLED: {
                throw new SQLException(queryExecution.status().stateChangeReason());
            }
        }
        return Optional.empty();
    }

    private long networkTimeoutMillis(Instant deadline) {
        return Math.max(0L, Math.min(this.configuration.networkTimeout().toMillis(), Duration.between(this.clock.instant(), deadline).toMillis()));
    }

    private ResultSet createResultSet(QueryExecution queryExecution) {
        return new AthenaResultSet(this.configuration.createResult(queryExecution), this);
    }

    private void checkClosed() throws SQLException {
        if (!this.open) {
            throw new SQLException("Statement is closed");
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
        }
        this.open = false;
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        if (this.queryExecutionId == null) {
            throw new SQLException("Cannot cancel a statement before it has started");
        }
        if (this.getResultSet() != null) {
            throw new SQLException("Cannot cancel an completed statement");
        }
        this.athenaClient.stopQueryExecution(b -> b.queryExecutionId(this.queryExecutionId));
    }

    @Override
    public ResultSet getResultSet() {
        return this.currentResultSet;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException(String.format("%s is not a wrapper for %s", this.getClass().getName(), iface.getName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        throw new SQLFeatureNotSupportedException("Athena does not support auto generated keys");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support auto generated keys");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support auto generated keys");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        throw new SQLFeatureNotSupportedException("Athena does not support updates");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support updates");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support updates");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.executeLargeUpdate(sql);
        }
        throw new SQLFeatureNotSupportedException("Athena does not support updates");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support updates");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support updates");
    }

    @Override
    public int getMaxFieldSize() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setMaxFieldSize(int max) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getMaxRows() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setMaxRows(int max) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setQueryTimeout(Duration timeout) {
        this.configuration = this.configuration.withQueryTimeout(timeout);
    }

    @Override
    public int getQueryTimeout() {
        return (int)this.configuration.queryTimeout().toMillis() / 1000;
    }

    @Override
    public void setQueryTimeout(int seconds) {
        this.setQueryTimeout(Duration.ofSeconds(seconds));
    }

    @Override
    public SQLWarning getWarnings() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void clearWarnings() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setCursorName(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getUpdateCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean getMoreResults() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Result set movements other than forward are not supported");
        }
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getFetchSize() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getResultSetConcurrency() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getResultSetType() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void addBatch(String sql) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void clearBatch() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int[] executeBatch() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Connection getConnection() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean getMoreResults(int current) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResultSet getGeneratedKeys() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getResultSetHoldability() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setPoolable(boolean poolable) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isPoolable() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void closeOnCompletion() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isCloseOnCompletion() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

