/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;

public class AthenaResultSetMetaData
implements ResultSetMetaData {
    private final QueryExecution queryExecution;
    private final ResultSetMetadata metaData;

    public AthenaResultSetMetaData(QueryExecution queryExecution, ResultSetMetadata metaData) {
        this.queryExecution = queryExecution;
        this.metaData = metaData;
    }

    private ColumnInfo getColumn(int n) {
        return (ColumnInfo)this.metaData.columnInfo().get(n - 1);
    }

    @Override
    public int getColumnCount() {
        return this.metaData.columnInfo().size();
    }

    @Override
    public String getColumnLabel(int column) {
        return this.getColumn(column).label();
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumn(column).name();
    }

    @Override
    public String getTableName(int column) {
        return this.getColumn(column).tableName();
    }

    @Override
    public String getSchemaName(int column) {
        return this.getColumn(column).schemaName();
    }

    @Override
    public String getCatalogName(int column) {
        return this.getColumn(column).catalogName();
    }

    @Override
    public int getPrecision(int column) {
        return this.getColumn(column).precision();
    }

    @Override
    public int getScale(int column) {
        return this.getColumn(column).scale();
    }

    @Override
    public int getColumnType(int column) {
        switch (this.getColumn(column).type()) {
            case "tinyint": {
                return -6;
            }
            case "smallint": {
                return 5;
            }
            case "integer": {
                return 4;
            }
            case "bigint": {
                return -5;
            }
            case "float": {
                return 6;
            }
            case "double": {
                return 8;
            }
            case "decimal": {
                return 3;
            }
            case "boolean": {
                return 16;
            }
            case "char": {
                return 1;
            }
            case "varchar": 
            case "json": 
            case "interval day to second": 
            case "interval year to month": {
                return 12;
            }
            case "varbinary": {
                return -3;
            }
            case "date": {
                return 91;
            }
            case "time": {
                return 92;
            }
            case "time with time zone": {
                return 2013;
            }
            case "timestamp": {
                return 93;
            }
            case "timestamp with time zone": {
                return 2014;
            }
            case "array": {
                return 2003;
            }
            case "map": 
            case "row": {
                return 2002;
            }
        }
        return 1111;
    }

    @Override
    public String getColumnTypeName(int column) {
        return this.getColumn(column).type();
    }

    @Override
    public String getColumnClassName(int column) {
        String typeName = this.getColumn(column).type();
        if (typeName.equals("varchar")) {
            return String.class.getName();
        }
        return Object.class.getName();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Calculating column display sizes is not supported");
    }

    @Override
    public boolean isAutoIncrement(int column) {
        this.getColumn(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return this.getColumn(column).caseSensitive();
    }

    @Override
    public boolean isSearchable(int column) {
        this.getColumn(column);
        return true;
    }

    @Override
    public boolean isCurrency(int column) {
        this.getColumn(column);
        return false;
    }

    @Override
    public int isNullable(int column) {
        switch (this.getColumn(column).nullable()) {
            case NULLABLE: {
                return 1;
            }
            case NOT_NULL: {
                return 0;
            }
        }
        return 2;
    }

    @Override
    public boolean isSigned(int column) {
        String typeName = this.getColumn(column).type();
        return typeName.equals("integer") || typeName.equals("bigint") || typeName.equals("smallint") || typeName.equals("tinyint") || typeName.equals("float") || typeName.equals("double") || typeName.equals("decimal");
    }

    @Override
    public boolean isReadOnly(int column) {
        this.getColumn(column);
        return true;
    }

    @Override
    public boolean isWritable(int column) {
        this.getColumn(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        this.getColumn(column);
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException(String.format("%s is not a wrapper for %s", this.getClass().getName(), iface.getName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    public String getQueryExecutionId() {
        return this.queryExecution.queryExecutionId();
    }

    public String getOutputLocation() {
        return this.queryExecution.resultConfiguration().outputLocation();
    }
}

