/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena;

import io.burt.athena.AthenaStatement;
import io.burt.athena.result.AthenaArray;
import io.burt.athena.result.Result;
import io.burt.athena.result.ResultPosition;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Pattern;

public class AthenaResultSet
implements ResultSet {
    private AthenaStatement statement;
    private boolean open;
    private Result result;
    private boolean lastWasNull;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern SPACE = Pattern.compile(" ");
    private static final DateTimeFormatter ATHENA_TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss.SSS[ VV][ zzzz]");
    private static final DateTimeFormatter ATHENA_TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS[ VV][ zzzz]");

    public AthenaResultSet(Result result, AthenaStatement statement) {
        this.statement = statement;
        this.open = true;
        this.result = result;
        this.lastWasNull = false;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    private void checkClosed() throws SQLException {
        if (!this.open) {
            throw new SQLException("Result set is closed");
        }
    }

    private void checkPosition(int columnIndex) throws SQLException {
        this.checkVerticalPosition();
        this.checkHorizontalPosition(columnIndex);
    }

    private void checkPosition(String columnLabel) throws SQLException {
        this.checkVerticalPosition();
        this.checkHorizontalPosition(this.findColumn(columnLabel));
    }

    private void checkVerticalPosition() throws SQLException {
        if (this.isBeforeFirst()) {
            throw new SQLException("Cannot read from a result set positioned before the first row");
        }
        if (this.isAfterLast()) {
            throw new SQLException("Cannot read from a result set positioned after the last row");
        }
    }

    private void checkHorizontalPosition(int columnIndex) throws SQLException {
        int columnCount = this.getMetaData().getColumnCount();
        if (columnIndex < 1) {
            throw new SQLException(String.format("Invalid column index %d", columnIndex));
        }
        if (columnIndex > columnCount) {
            throw new SQLException(String.format("Column index out of bounds (%d > %d)", columnIndex, columnCount));
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        return this.result.next();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.result.getMetaData();
    }

    @Override
    public void close() throws SQLException {
        this.statement = null;
        this.open = false;
        if (this.result != null) {
            try {
                this.result.close();
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            this.result = null;
        }
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.result.getPosition() == ResultPosition.BEFORE_FIRST;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.result.getPosition() == ResultPosition.AFTER_LAST;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.result.getPosition() == ResultPosition.FIRST;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        return this.result.getPosition() == ResultPosition.LAST;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.isBeforeFirst() || this.isAfterLast()) {
            return 0;
        }
        return this.result.getRowNumber();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Result set movements other than forward are not supported");
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new SQLException(String.format("Fetch size cannot be negative (got %d)", rows));
        }
        this.result.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.result.getFetchSize();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        ResultSetMetaData metaData = this.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            if (!metaData.getColumnLabel(i).equals(columnLabel)) continue;
            return i;
        }
        throw new SQLDataException(String.format("Result set does not contain any column with label \"%s\"", columnLabel));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException(String.format("%s is not a wrapper for %s", this.getClass().getName(), iface.getName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Holdability is not defined for Athena");
    }

    @Override
    public SQLWarning getWarnings() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void clearWarnings() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("Holdability is not defined for Athena");
    }

    @Override
    public boolean wasNull() {
        return this.lastWasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkPosition(columnIndex);
        String value = this.result.getString(columnIndex);
        this.lastWasNull = value == null;
        return value;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkPosition(columnLabel);
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    private Boolean convertToBoolean(String str) {
        return str != null && !str.equals("0") && !str.equalsIgnoreCase("false");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.convertToBoolean(this.getString(columnIndex));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.convertToBoolean(this.getString(columnLabel));
    }

    private byte convertToByte(String str) throws SQLException {
        if (str == null) {
            return 0;
        }
        try {
            return Byte.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to byte", str), nfe);
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.convertToByte(this.getString(columnIndex));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.convertToByte(this.getString(columnLabel));
    }

    private short convertToShort(String str) throws SQLException {
        if (str == null) {
            return 0;
        }
        try {
            return Short.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to short", str), nfe);
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.convertToShort(this.getString(columnIndex));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.convertToShort(this.getString(columnLabel));
    }

    private int convertToInteger(String str) throws SQLException {
        if (str == null) {
            return 0;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to integer", str), nfe);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.convertToInteger(this.getString(columnIndex));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.convertToInteger(this.getString(columnLabel));
    }

    private long convertToLong(String str) throws SQLException {
        if (str == null) {
            return 0L;
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to long", str), nfe);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.convertToLong(this.getString(columnIndex));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.convertToLong(this.getString(columnLabel));
    }

    private float convertToFloat(String str) throws SQLException {
        if (str == null) {
            return 0.0f;
        }
        try {
            Float f = Float.valueOf(str);
            if (f.isInfinite()) {
                throw new SQLDataException(String.format("Cannot convert \"%s\" to float", str));
            }
            return f.floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to float", str), nfe);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.convertToFloat(this.getString(columnIndex));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.convertToFloat(this.getString(columnLabel));
    }

    private double convertToDouble(String str) throws SQLException {
        if (str == null) {
            return 0.0;
        }
        try {
            Double d = Double.valueOf(str);
            if (d.isInfinite()) {
                throw new SQLDataException(String.format("Cannot convert \"%s\" to double", str));
            }
            return d;
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to double", str), nfe);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.convertToDouble(this.getString(columnIndex));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.convertToDouble(this.getString(columnLabel));
    }

    private BigDecimal convertToBigDecimal(String str) throws SQLException {
        if (str == null) {
            return null;
        }
        try {
            return new BigDecimal(str);
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("Could not convert \"%s\" to BigDecimal", str), nfe);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.convertToBigDecimal(this.getString(columnIndex));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.convertToBigDecimal(this.getString(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.convertToBigDecimal(this.getString(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.convertToBigDecimal(this.getString(columnLabel));
    }

    private byte[] convertToBytes(String str, boolean isVarbinary) {
        if (str == null) {
            return null;
        }
        if (isVarbinary) {
            String[] hextets = SPACE.split(str);
            byte[] bytes = new byte[hextets.length];
            for (int i = 0; i < hextets.length; ++i) {
                bytes[i] = Byte.valueOf(hextets[i], 16);
            }
            return bytes;
        }
        return str.getBytes(UTF_8);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.convertToBytes(this.getString(columnIndex), this.getMetaData().getColumnTypeName(columnIndex).equalsIgnoreCase("varbinary"));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    private Date convertToDate(String str) throws SQLException {
        if (str == null) {
            return null;
        }
        try {
            LocalDate date = DateTimeFormatter.ISO_DATE.parse((CharSequence)str, TemporalQueries.localDate());
            return Date.valueOf(date);
        }
        catch (DateTimeParseException dtpe) {
            throw new SQLDataException(String.format("Could not convert \"%s\" to Date", str), dtpe);
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.convertToDate(this.getString(columnIndex));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.convertToDate(this.getString(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("Date/time retrieval relative to a Calendar not supported");
    }

    @Override
    public Date getDate(String columnLabel, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("Date/time retrieval relative to a Calendar not supported");
    }

    private Time convertToTime(String str) throws SQLException {
        if (str == null) {
            return null;
        }
        try {
            LocalTime time = ATHENA_TIME_FORMAT.parse((CharSequence)str, TemporalQueries.localTime());
            ZoneId zone = ATHENA_TIME_FORMAT.parse((CharSequence)str, TemporalQueries.zone());
            if (zone != null) {
                time = LocalDateTime.of(LocalDate.now(), time).atZone(zone).withZoneSameInstant(ZoneId.systemDefault()).toLocalTime();
            }
            return Time.valueOf(time);
        }
        catch (DateTimeParseException dtpe) {
            throw new SQLDataException(String.format("Could not convert \"%s\" to Time", str), dtpe);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.convertToTime(this.getString(columnIndex));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Date/time retrieval relative to a Calendar not supported");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Date/time retrieval relative to a Calendar not supported");
    }

    private Timestamp convertToTimestamp(String str) throws SQLException {
        if (str == null) {
            return null;
        }
        try {
            TemporalAccessor parsedTimestamp = ATHENA_TIMESTAMP_FORMAT.parseBest(str, ZonedDateTime::from, LocalDateTime::from);
            ZonedDateTime zonedTimestamp = parsedTimestamp instanceof ZonedDateTime ? (ZonedDateTime)parsedTimestamp : ((LocalDateTime)parsedTimestamp).atZone(ZoneId.systemDefault());
            return new Timestamp(zonedTimestamp.toInstant().toEpochMilli());
        }
        catch (DateTimeParseException e) {
            throw new SQLDataException(String.format("Could not convert \"%s\" to Timestamp", str), e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.convertToTimestamp(this.getString(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Date/time retrieval relative to a Calendar not supported");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Date/time retrieval relative to a Calendar not supported");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        switch (this.getMetaData().getColumnType(columnIndex)) {
            case -6: {
                byte b = this.getByte(columnIndex);
                return this.wasNull() ? null : Integer.valueOf(b);
            }
            case 5: {
                short s = this.getShort(columnIndex);
                return this.wasNull() ? null : Integer.valueOf(s);
            }
            case 4: {
                int i = this.getInt(columnIndex);
                return this.wasNull() ? null : Integer.valueOf(i);
            }
            case -5: {
                long l = this.getLong(columnIndex);
                return this.wasNull() ? null : Long.valueOf(l);
            }
            case 6: {
                float f = this.getFloat(columnIndex);
                return this.wasNull() ? null : Float.valueOf(f);
            }
            case 8: {
                double d = this.getDouble(columnIndex);
                return this.wasNull() ? null : Double.valueOf(d);
            }
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case 16: {
                boolean o = this.getBoolean(columnIndex);
                return this.wasNull() ? null : Boolean.valueOf(o);
            }
            case -3: {
                return this.getBytes(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: 
            case 2013: {
                return this.getTime(columnIndex);
            }
            case 93: 
            case 2014: {
                return this.getTimestamp(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
        }
        return this.getString(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Converting to custom types is not supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Converting to custom types is not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Converting to custom types is not supported");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Converting to custom types is not supported");
    }

    @Override
    public Ref getRef(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Ref getRef(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Blob getBlob(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Blob getBlob(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Clob getClob(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Clob getClob(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private Array convertToArray(String str) throws SQLException {
        if (str == null) {
            return null;
        }
        if (str.startsWith("[") && str.endsWith("]")) {
            String[] elements = str.substring(1, str.length() - 1).split(", ");
            return new AthenaArray(elements);
        }
        throw new SQLDataException(String.format("Could not convert \"%s\" to an array", str));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.convertToArray(this.getString(columnIndex));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.convertToArray(this.getString(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public NClob getNClob(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public URL getURL(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public URL getURL(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public RowId getRowId(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public RowId getRowId(String columnLabel) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private void movementsNotSupported() throws SQLException {
        throw new SQLFeatureNotSupportedException("Result set movements other than forward are not supported");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.movementsNotSupported();
    }

    @Override
    public void afterLast() throws SQLException {
        this.movementsNotSupported();
    }

    @Override
    public boolean first() throws SQLException {
        this.movementsNotSupported();
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.movementsNotSupported();
        return false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (row < 1) {
            throw new SQLException(String.format("Invalid row number %d", row));
        }
        if (row < this.result.getRowNumber()) {
            throw new SQLException(String.format("Only forward movement is supported (cannot go back to %d from %d)", row, this.result.getRowNumber()));
        }
        boolean status = false;
        while (this.result.getRowNumber() < row) {
            status = this.next();
        }
        return status;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (rows < 1) {
            throw new SQLException("Only forward relative movement is supported");
        }
        boolean status = false;
        for (int i = 0; i < rows; ++i) {
            status = this.next();
        }
        return status;
    }

    @Override
    public boolean previous() throws SQLException {
        this.movementsNotSupported();
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    private void mutationsNotSupported() throws SQLException {
        throw new SQLFeatureNotSupportedException("Mutation of result sets is not supported");
    }

    @Override
    public void insertRow() throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateRow() throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.mutationsNotSupported();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.mutationsNotSupported();
    }
}

