/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena;

import io.burt.athena.AthenaDriver;
import io.burt.athena.configuration.ConnectionConfigurationFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class AthenaDataSource
implements DataSource {
    private final Driver driver;
    private final Properties properties;
    private String databaseName;

    public AthenaDataSource() {
        this(new ConnectionConfigurationFactory());
    }

    AthenaDataSource(ConnectionConfigurationFactory connectionConfigurationFactory) {
        this.driver = new AthenaDriver(connectionConfigurationFactory);
        this.databaseName = "default";
        this.properties = new Properties();
    }

    public void setRegion(String region) {
        this.properties.setProperty("region", region);
    }

    public void setDatabase(String name) {
        this.databaseName = name;
    }

    public void setWorkGroup(String name) {
        this.properties.setProperty("workGroup", name);
    }

    public void setOutputLocation(String uri) {
        this.properties.setProperty("outputLocation", uri);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.driver.connect(AthenaDriver.createURL(this.databaseName), this.properties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException("Connections cannot be created with username and password, see the documentation for how to configure AWS IAM credentials");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException(String.format("%s is not a wrapper for %s", this.getClass().getName(), iface.getName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging is not used by this data source");
    }
}

