/*
 * Decompiled with CFR 0.152.
 */
package io.burt.athena;

import io.burt.athena.AthenaDatabaseMetaData;
import io.burt.athena.AthenaStatement;
import io.burt.athena.configuration.ConnectionConfiguration;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class AthenaConnection
implements Connection {
    private ConnectionConfiguration configuration;
    private DatabaseMetaData metaData;
    private boolean open;

    AthenaConnection(ConnectionConfiguration configuration) {
        this.configuration = configuration;
        this.metaData = null;
        this.open = true;
    }

    private void checkClosed() throws SQLException {
        if (!this.open) {
            throw new SQLException("Connection is closed");
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return new AthenaStatement(this.configuration, Clock.systemDefaultZone());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1003 && resultSetConcurrency == 1007) {
            return this.createStatement();
        }
        if (resultSetConcurrency == 1007) {
            throw new SQLFeatureNotSupportedException("Only read only result sets are supported");
        }
        throw new SQLFeatureNotSupportedException("Only forward result sets are supported");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Holdability is not defined for Athena");
    }

    @Override
    public void close() throws SQLException {
        try {
            this.open = false;
            this.configuration.close();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    @Override
    public boolean isValid(int timeout) {
        return this.open;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException(String.format("%s is not a wrapper for %s", this.getClass().getName(), iface.getName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support prepared statements");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support prepared statements");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support prepared statements");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support prepared statements");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support prepared statements");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support prepared statements");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not have stored procedures");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not have stored procedures");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not have stored procedures");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support transactions");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support transactions");
    }

    @Override
    public DatabaseMetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = new AthenaDatabaseMetaData(this);
        }
        return this.metaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public void setSchema(String schema) {
        this.configuration = this.configuration.withDatabaseName(schema);
    }

    @Override
    public String getSchema() {
        return this.configuration.databaseName();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support changing catalogs");
    }

    @Override
    public String getCatalog() {
        return "AwsDataCatalog";
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return Collections.emptyMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Type maps are not supported");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Holdability is not defined for Athena");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Holdability is not defined for Athena");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support savepoints");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support savepoints");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support savepoints");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkClosed();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), Collections.emptyMap(), (Throwable)e);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkClosed();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), Collections.emptyMap(), (Throwable)e);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return new Properties();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        this.configuration = this.configuration.withNetworkTimeout(Duration.ofMillis(milliseconds));
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        return (int)this.configuration.networkTimeout().toMillis();
    }

    @Override
    public Clob createClob() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Blob createBlob() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public NClob createNClob() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SQLXML createSQLXML() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void abort(Executor executor) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

