/*
 * Decompiled with CFR 0.152.
 */
package io.bretty.console.table;

import io.bretty.console.table.Alignment;
import io.bretty.console.table.Column;
import io.bretty.console.table.ColumnFormatter;
import io.bretty.console.table.TextColumnFormatter;
import java.util.ArrayList;
import java.util.List;

public final class Table {
    private String[][] table;
    private int charCount;
    private String s = null;
    private static final char VERTICAL_SEPARATOR = '|';

    public static Table of(Object[][] data, Alignment al, int width) {
        TextColumnFormatter tf = new TextColumnFormatter(al, width);
        Table t = new Table();
        t.table = new String[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                t.table[i][j] = tf.format(data[i][j].toString());
            }
        }
        t.charCount = data.length * (data[0].length * (width + 1)) + 2;
        return t;
    }

    public static <T> Table of(String[] headers, T[][] data, ColumnFormatter<T> f) {
        int i;
        if (data.length == 0 || data[0].length != headers.length) {
            // empty if block
        }
        Table t = new Table();
        t.table = new String[data.length + 1][data[0].length];
        ColumnFormatter<String> tcf = ColumnFormatter.text(f);
        for (i = 0; i < headers.length; ++i) {
            t.table[0][i] = tcf.format(headers[i]);
        }
        for (i = 1; i <= data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                t.table[i][j] = f.format(data[i - 1][j]);
            }
        }
        t.charCount = data.length * (data[0].length * (f.width + 1)) + 2;
        return t;
    }

    public static <T> Table of(T[][] data, ColumnFormatter<T> f) {
        Table t = new Table();
        t.table = new String[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                t.table[i][j] = f.format(data[i][j]);
            }
        }
        t.charCount = data.length * (data[0].length * (f.width + 1)) + 2;
        return t;
    }

    private Table() {
    }

    public String toString() {
        if (this.s == null) {
            StringBuilder sb = new StringBuilder(this.charCount);
            for (int i = 0; i < this.table.length; ++i) {
                sb.append('|');
                for (int j = 0; j < this.table[0].length; ++j) {
                    sb.append(this.table[i][j]);
                    sb.append('|');
                }
                sb.append('\n');
            }
            sb.deleteCharAt(sb.length() - 1);
            this.s = sb.toString();
        }
        return this.s;
    }

    static /* synthetic */ String[][] access$102(Table x0, String[][] x1) {
        x0.table = x1;
        return x1;
    }

    public static final class Builder {
        private static final int DEFAULT_COLUMN_NUMBER = 15;
        private List<Column> columns = new ArrayList<Column>(15);
        private int totalWidth = 0;

        public <T> Builder(String header, T[] data, ColumnFormatter<T> formatter) {
            this.addColumn(header, data, formatter);
        }

        public <T> Builder addColumn(String header, T[] data, ColumnFormatter<T> formatter) {
            Column c = new Column(header, data, formatter);
            this.columns.add(c);
            this.totalWidth += c.width();
            return this;
        }

        public Table build() {
            int columnCount = this.columns.size();
            int rowCount = 1;
            for (Column c : this.columns) {
                int current = c.size();
                if (current <= rowCount) continue;
                rowCount = current;
            }
            Table t = new Table();
            Table.access$102(t, new String[rowCount][columnCount]);
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < columnCount; ++j) {
                    ((Table)t).table[i][j] = this.columns.get(j).get(i);
                }
            }
            t.charCount = rowCount * (this.totalWidth + columnCount + 2);
            return t;
        }
    }
}

