/*
 * Decompiled with CFR 0.152.
 */
package io.bretty.console.table;

import io.bretty.console.table.Alignment;
import io.bretty.console.table.NumberColumnFormatter;
import io.bretty.console.table.Precision;

class CurrencyNumberColumnFormatter
extends NumberColumnFormatter {
    private String symbol;

    protected CurrencyNumberColumnFormatter(Alignment al, int width, Precision p, String symbol) {
        super(al, width, p);
        this.symbol = symbol;
    }

    @Override
    public String format(Number n) {
        boolean negative;
        double value = n.doubleValue();
        boolean bl = negative = Double.compare(value, 0.0) < 0;
        if (negative) {
            value = -value;
        }
        String abs = this.symbol;
        if (this.symbol.length() > 1) {
            abs = abs + " ";
        }
        abs = abs + this.precision.format(value);
        if (negative) {
            abs = "-" + abs;
        }
        return this.formatString(abs, this.width);
    }
}

