/*
 * Decompiled with CFR 0.152.
 */
package io.bretty.console.table;

import io.bretty.console.table.Alignment;
import io.bretty.console.table.CurrencyNumberColumnFormatter;
import io.bretty.console.table.DateTimeColumnFormatter;
import io.bretty.console.table.NumberColumnFormatter;
import io.bretty.console.table.PercentageNumberColumnFormatter;
import io.bretty.console.table.Precision;
import io.bretty.console.table.TextColumnFormatter;
import java.text.DateFormat;
import java.util.Date;

public abstract class ColumnFormatter<T> {
    private static ColumnFormatter<String> textFormatter = new TextColumnFormatter();
    protected Alignment al;
    protected int width;

    public static ColumnFormatter<Number> currency(Alignment al, int width, Precision p, String symbol) {
        return new CurrencyNumberColumnFormatter(al, width, p, symbol);
    }

    public static ColumnFormatter<Date> dateTime(Alignment al, int width, DateFormat df) {
        return new DateTimeColumnFormatter(al, width, df);
    }

    public static <T> String formatText(ColumnFormatter<T> cf, String s) {
        ColumnFormatter.textFormatter.al = cf.al;
        ColumnFormatter.textFormatter.width = cf.width;
        return textFormatter.format(s);
    }

    public static ColumnFormatter<Number> number(Alignment al, int width, Precision p) {
        return new NumberColumnFormatter(al, width, p);
    }

    public static ColumnFormatter<Number> percentage(Alignment al, int width, Precision p) {
        return new PercentageNumberColumnFormatter(al, width, p);
    }

    public static ColumnFormatter<String> text(Alignment al, int width) {
        return new TextColumnFormatter(al, width);
    }

    public static <T> ColumnFormatter<String> text(ColumnFormatter<T> cf) {
        return new TextColumnFormatter(cf.al, cf.width);
    }

    protected ColumnFormatter() {
    }

    protected ColumnFormatter(Alignment al, int width) {
        this.al = al;
        this.width = width;
    }

    public abstract String format(T var1);

    protected String formatString(String s, int width) {
        return this.al.format(s, width, ' ');
    }

    public final Alignment getAlignment() {
        return this.al;
    }

    public final int getWidth() {
        return this.width;
    }
}

