/*
 * Decompiled with CFR 0.152.
 */
package io.bretty.console.table;

public enum Alignment {
    LEFT{

        @Override
        public String format(String input, int width, char pad) {
            if (width < input.length()) {
                return input.substring(0, width);
            }
            if (width == input.length()) {
                return input;
            }
            return Position.AFTER.pad(input, pad, width - input.length());
        }
    }
    ,
    RIGHT{

        @Override
        public String format(String input, int width, char pad) {
            if (width < input.length()) {
                return input.substring(input.length() - width, input.length());
            }
            if (width == input.length()) {
                return input;
            }
            return Position.BEFORE.pad(input, pad, width - input.length());
        }
    }
    ,
    CENTER{

        @Override
        public String format(String input, int width, char pad) {
            if (width < input.length()) {
                int redun = (input.length() - width) / 2;
                return input.substring(redun, input.length() - redun);
            }
            if (input.length() == width) {
                return input;
            }
            int firstHalf = (width - input.length()) / 2;
            int secondHalf = width - input.length() - firstHalf;
            input = Position.BEFORE.pad(input, pad, firstHalf);
            return Position.AFTER.pad(input, pad, secondHalf);
        }
    };


    public abstract String format(String var1, int var2, char var3);

    static enum Position {
        BEFORE{

            @Override
            protected String pad(String input, char p, int count) {
                StringBuilder sb = new StringBuilder(input.length() + count);
                sb = 1.append(sb, p, count);
                sb.append(input);
                return sb.toString();
            }
        }
        ,
        AFTER{

            @Override
            protected String pad(String input, char p, int count) {
                StringBuilder sb = new StringBuilder(input.length() + count);
                sb.append(input);
                sb = 2.append(sb, p, count);
                return sb.toString();
            }
        };


        protected static StringBuilder append(StringBuilder sb, char p, int count) {
            for (int i = 0; i < count; ++i) {
                sb.append(p);
            }
            return sb;
        }

        protected abstract String pad(String var1, char var2, int var3);
    }
}

