/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import io.branch.referral.ApkParser;
import java.io.InputStream;
import java.util.UUID;
import java.util.jar.JarFile;

public class SystemObserver {
    public static final String BLANK = "bnc_no_value";
    private Context context_;
    private boolean isRealHardwareId;

    public SystemObserver(Context context) {
        this.context_ = context;
        this.isRealHardwareId = true;
    }

    public String getUniqueID() {
        if (this.context_ != null) {
            String androidID = Settings.Secure.getString((ContentResolver)this.context_.getContentResolver(), (String)"android_id");
            if (androidID == null) {
                androidID = UUID.randomUUID().toString();
                this.isRealHardwareId = false;
            }
            return androidID;
        }
        return BLANK;
    }

    public boolean hasRealHardwareId() {
        return this.isRealHardwareId;
    }

    public String getURIScheme() {
        PackageManager pm = this.context_.getPackageManager();
        try {
            ApplicationInfo ai = pm.getApplicationInfo(this.context_.getPackageName(), 0);
            String sourceApk = ai.publicSourceDir;
            Log.i((String)"BranchUriSchemer", (String)("source APK file " + sourceApk));
            try {
                JarFile jf = new JarFile(sourceApk);
                InputStream is = jf.getInputStream(jf.getEntry("AndroidManifest.xml"));
                byte[] xml = new byte[is.available()];
                is.read(xml);
                String scheme = new ApkParser().decompressXML(xml);
                jf.close();
                return scheme;
            }
            catch (Exception exception) {
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return BLANK;
    }

    public String getAppVersion() {
        try {
            PackageInfo packageInfo = this.context_.getPackageManager().getPackageInfo(this.context_.getPackageName(), 0);
            if (packageInfo.versionName != null) {
                return packageInfo.versionName;
            }
            return BLANK;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return BLANK;
        }
    }

    public String getCarrier() {
        String ret;
        TelephonyManager telephonyManager = (TelephonyManager)this.context_.getSystemService("phone");
        if (telephonyManager != null && (ret = telephonyManager.getNetworkOperatorName()) != null) {
            return ret;
        }
        return BLANK;
    }

    public boolean getBluetoothPresent() {
        try {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter != null) {
                return bluetoothAdapter.isEnabled();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public String getBluetoothVersion() {
        if (Build.VERSION.SDK_INT >= 8) {
            if (Build.VERSION.SDK_INT >= 18 && this.context_.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                return "ble";
            }
            if (this.context_.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                return "classic";
            }
        }
        return BLANK;
    }

    public boolean getNFCPresent() {
        try {
            return this.context_.getPackageManager().hasSystemFeature("android.hardware.nfc");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean getTelephonePresent() {
        try {
            return this.context_.getPackageManager().hasSystemFeature("android.hardware.telephony");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getPhoneBrand() {
        return Build.MANUFACTURER;
    }

    public String getPhoneModel() {
        return Build.MODEL;
    }

    public String getOS() {
        return "Android";
    }

    public int getOSVersion() {
        return Build.VERSION.SDK_INT;
    }

    @SuppressLint(value={"NewApi"})
    public int getUpdateState() {
        if (Build.VERSION.SDK_INT >= 9) {
            try {
                PackageInfo packageInfo = this.context_.getPackageManager().getPackageInfo(this.context_.getPackageName(), 0);
                if (packageInfo.lastUpdateTime != packageInfo.firstInstallTime) {
                    return 1;
                }
                return 0;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return 0;
    }

    public DisplayMetrics getScreenDisplay() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = ((WindowManager)this.context_.getSystemService("window")).getDefaultDisplay();
        display.getMetrics(displayMetrics);
        return displayMetrics;
    }

    public boolean getWifiConnected() {
        if (this.context_.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0) {
            ConnectivityManager connManager = (ConnectivityManager)this.context_.getSystemService("connectivity");
            NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
            return wifiInfo.isConnected();
        }
        return false;
    }
}

