/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.content.SharedPreferences;
import io.branch.referral.ServerRequest;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerRequestQueue {
    private static final String PREF_KEY = "BNCServerRequestQueue";
    private static ServerRequestQueue SharedInstance;
    private SharedPreferences sharedPref;
    private SharedPreferences.Editor editor;
    private List<ServerRequest> queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerRequestQueue getInstance(Context c) {
        if (SharedInstance != null) return SharedInstance;
        Class<ServerRequestQueue> clazz = ServerRequestQueue.class;
        synchronized (ServerRequestQueue.class) {
            if (SharedInstance != null) return SharedInstance;
            SharedInstance = new ServerRequestQueue(c);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SharedInstance;
        }
    }

    private ServerRequestQueue(Context c) {
        this.sharedPref = c.getSharedPreferences("BNC_Server_Request_Queue", 0);
        this.editor = this.sharedPref.edit();
        this.queue = this.retrieve();
    }

    private void persist() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JSONArray jsonArr = new JSONArray();
                List list = ServerRequestQueue.this.queue;
                synchronized (list) {
                    block15: {
                        Iterator iter = ServerRequestQueue.this.queue.iterator();
                        while (iter.hasNext()) {
                            JSONObject json = ((ServerRequest)iter.next()).toJSON();
                            if (json == null) continue;
                            jsonArr.put((Object)json);
                        }
                        try {
                            try {
                                ServerRequestQueue.this.editor.putString(ServerRequestQueue.PREF_KEY, jsonArr.toString()).commit();
                            }
                            catch (ConcurrentModificationException concurrentModificationException) {
                                try {
                                    ServerRequestQueue.this.editor.putString(ServerRequestQueue.PREF_KEY, jsonArr.toString()).commit();
                                }
                                catch (ConcurrentModificationException concurrentModificationException2) {}
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                ServerRequestQueue.this.editor.putString(ServerRequestQueue.PREF_KEY, jsonArr.toString()).commit();
                            }
                            catch (ConcurrentModificationException concurrentModificationException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            ServerRequestQueue.this.editor.putString(ServerRequestQueue.PREF_KEY, jsonArr.toString()).commit();
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {
                            // empty catch block
                        }
                    }
                }
            }
        }).start();
    }

    private List<ServerRequest> retrieve() {
        List<ServerRequest> result = Collections.synchronizedList(new LinkedList());
        String jsonStr = this.sharedPref.getString(PREF_KEY, null);
        if (jsonStr != null) {
            try {
                JSONArray jsonArr = new JSONArray(jsonStr);
                int i = 0;
                while (i < jsonArr.length()) {
                    JSONObject json = jsonArr.getJSONObject(i);
                    ServerRequest req = ServerRequest.fromJSON(json);
                    if (req != null) {
                        result.add(req);
                    }
                    ++i;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public int getSize() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.size() == 0;
    }

    public void enqueue(ServerRequest request) {
        if (request != null) {
            this.queue.add(request);
            this.persist();
        }
    }

    public ServerRequest dequeue() {
        ServerRequest req = null;
        try {
            req = this.queue.remove(0);
            this.persist();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return req;
    }

    public ServerRequest peek() {
        ServerRequest req = null;
        try {
            req = this.queue.get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return req;
    }

    public ServerRequest peekAt(int index) {
        ServerRequest req = null;
        try {
            req = this.queue.get(index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return req;
    }

    public void insert(ServerRequest request, int index) {
        try {
            this.queue.add(index, request);
            this.persist();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public ServerRequest removeAt(int index) {
        ServerRequest req = null;
        try {
            req = this.queue.remove(index);
            this.persist();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsInstallOrOpen() {
        List<ServerRequest> list = this.queue;
        synchronized (list) {
            ServerRequest req;
            Iterator<ServerRequest> iter = this.queue.iterator();
            do {
                if (!iter.hasNext()) {
                    return false;
                }
                req = iter.next();
                if (req.getTag().equals("t_register_install")) return true;
            } while (!req.getTag().equals("t_register_open"));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<ServerRequest> list = this.queue;
        synchronized (list) {
            for (ServerRequest req : this.queue) {
                sb.append(String.valueOf(req.getTag()) + "; ");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveInstallOrOpenToFront(String tag, int networkCount) {
        List<ServerRequest> list = this.queue;
        synchronized (list) {
            Iterator<ServerRequest> iter = this.queue.iterator();
            while (iter.hasNext()) {
                ServerRequest req = iter.next();
                if (!req.getTag().equals("t_register_install") && !req.getTag().equals("t_register_open")) continue;
                iter.remove();
                break;
            }
        }
        ServerRequest req = new ServerRequest(tag);
        if (networkCount == 0) {
            this.insert(req, 0);
        } else {
            this.insert(req, 1);
        }
    }
}

